---
title: "Extension Methods"
page-title: "Extension Methods - Shared Library Reference"
order: 13
---
# Extension Methods

Various extension methods are provided for several Avalonia types.

> [!TIP]
> Additional [extension methods for common .NET types](../core/extension-methods.md) are included in the Core Library.

> [!IMPORTANT]
> The `ActiproSoftware.UI.Avalonia` namespace must be imported for the extensions described below to be available.

## CornerRadius Extensions
The [CornerRadiusExtensions](xref:@ActiproUIRoot.CornerRadiusExtensions) type contains extension methods for the `CornerRadius` type.

| Type | Description |
|-----|-----|
| [IsZero](xref:@ActiproUIRoot.CornerRadiusExtensions.IsZero*) | Returns whether all radii in the `CornerRadius` are `0.0`. |

## Thickness Extensions

The [ThicknessExtensions](xref:@ActiproUIRoot.ThicknessExtensions) type contains extension methods for the `Thickness` type.

| Type | Description |
|-----|-----|
| [IsZero](xref:@ActiproUIRoot.ThicknessExtensions.IsZero*) | Returns whether all sides in the `Thickness` are `0.0`. |
