---
title: "Overview"
page-title: "Fundamentals Reference"
order: 1
---
# Overview

Actipro Fundamentals is a library that contains professionally-developed controls and components for building high-quality applications.

![Screenshot](images/overview.png)

*Various controls in the Fundamentals library*

> [!IMPORTANT]
> The Actipro Fundamentals is a paid product!  See our [Licensing](../licensing.md) topic for more details.

## Features

### General Controls

- [Avatar](controls/avatar.md) represents people or objects.
- [AvatarGroup](controls/avatar-group.md) renders multiple [Avatar](controls/avatar.md) controls.
- [Badge](controls/badge.md) displays contextual information for other elements or can be used stand-alone.
- [Card](controls/card.md) displays visually grouped information for a single subject.
- [CircularProgressBar](controls/circular-progressbar.md) displays a ranged progress value using fluent animations.  It is similar to a native linear `ProgressBar`, except that it renders the progress in a ring shape.
- [InfoBar](controls/info-bar.md) displays essential information to a user without disrupting the user flow.
- [RingSpinner](controls/progress-spinners.md) renders a circular busy indicator.
- [SegmentedBar](controls/segmented-bar.md) allows a user to select a single item with support for fluent animations when changing selection.
- [SettingsCard](controls/settings-card.md), [SettingsExpander](controls/settings-expander.md), and [Settings Group](controls/settings-group.md) controls are used together to organize and present configurable settings.
- [User Prompt](user-prompt/index.md) displays **MessageBox** and **Task Dialog** style prompts.

### Panels

- [MultiColumnPanel](xref:@ActiproUIRoot.Controls.MultiColumnPanel) arranges child elements in multiple columns, collapsing columns down as available space decreases.