# Java Annotations

## Definition and uses

Annotations is a form of metadata that provide data about a program that is not part of the program itself. Annotations have no direct effect on the operation of the code they annotate

Annotations have a number of uses, among them:

1. **Information for the compiler** — Annotations can be used by the compiler to detect errors or suppress warnings.
1. **Compile-time and deployment-time processing** — Software tools can process annotation information to generate code, XML files, and so forth.
1. **Runtime processing** — Some annotations are available to be examined at runtime.

:warning: Annotations have no effect on a program at runtime. Please note that an annotation does not execute any code or inject any logic that alters the normal behavior of the program.

:warning: Please refer to [this](https://docs.oracle.com/javase/tutorial/java/annotations/index.html) Java Documentation for more details. **Information provided here are taken from various resources**. 