#### App is live and running at 

### https://nextjs-ecommerce-typescript.vercel.app/


 - don't forget to leave a star ! :)

## Authors

- [Abdullah Moiz](https://www.github.com/Abdullah-moiz)

## Features

#### NOTE
 - Admin Dashboard is only accessible to you if you clone it you can't Signup for Admin Account I have added dummy Product and categories 


#### multi User Login System
- SignIn / SignUp ✔
- Forget Password ✔
- JWT validation on each Authorized Request ✔
- Authorization validation for Admin Access and Customer Access ✔

# ADMIN PANEL
 - Add a product ✔
 - view Product ✔
 - Delete a Product ✔
 - update product ✔
 - Add a Category ✔
 - view Category (Data tables) ✔
 - update Category  ✔
 - Delete category ✔
 - search category By name ✔
 - search product by category Name ✔
 - Handle Order Delivery  ✔
 - Pending Order  List ✔
 - Completed Order List ✔

# Customer
- View Product & Category ✔
- view product related to specific category ✔
- view dynamic pages detail with breadcamp ✔
- Add product to cart ✔
- Remove Product from cart ✔
- Increase Decrease cart Item  Quantity ✔ (IF product Instock Quantity is less then your cart quantity then you are unable to  increase that product Quantity)
- Alert if InStock Quantity isn't Available ✔
- Bookmark favourite Product ✔
- remove product from bookmark ✔
- Order a Product ✔
- After Creating an Order Product Exists in Cart for current User will be Cleared ✔
- track Order Status ✔
- View Order Detail ✔

#### Note 
More Functionality will be added with time



## Tech
- Nextjs 13
- Typescript
- tailwind css
- Redux toolkit
- joi validation
- mongoDB
- SWR hooks for fetching API 

## Environment Variables

To run this project, you will need to add the following environment variables to your .env file

`DB_URI` = Your mongoDB URL

`JWT_SECREAT` = Your custom JWT_SECREAT key

`NEXT_PUBLIC_API_BASE_URL` =  Base URL for localhost  => http://localhost:3000


## Installation

Install my-project with npm

```bash
  npm install
  npm run dev (for development server)
  npm run build (for Production)
  npm run preview (To View Production Server )
```

### Screen shots
####  Admin Dashboard
![1](https://user-images.githubusercontent.com/90745903/236361005-89f40e51-3aff-4e66-8aa2-941138a15316.png)

#### Admin Add Product
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/8c2129fa-bbc4-4d03-b249-a9e4a26ba769)

#### Admin Add Category
![image](https://user-images.githubusercontent.com/90745903/236360988-8b7e6307-5365-4486-8404-b8ddaf1ab486.png)

#### Admin View Category
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/79d3384f-0aed-4ca0-9bb6-c74a42042cfa)

#### Admin View Product
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/f0a85e4a-891e-4c1f-86fe-206dedb6034c)

#### Admin Search Product with category Name
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/76f09c2a-4c16-4784-afa0-5f424a42430f)

#### Admin Search category with category Name
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/600bb84b-9401-48e9-90b8-44891f794b81)

#### Pending Order List
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/66f07720-dc2f-4a05-98fc-d9c422665dc9)


#### Completed Order List
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/278e33ae-b7bb-4cf2-8ed3-18e06d1f368c)



#### Landing Page 

![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/a4a21833-3f42-479f-99b8-1dba1b459f1b)

![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/bb8141aa-9ded-4a77-a653-c86733bd7871)

![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/9970dabd-eb75-4c6b-8349-d55897a5f9c4)


#### view Product of Specific category with Dynamic Breadcamp 
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/7babf0cb-2b67-439d-9859-61f21d2ce453)

![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/df41987a-d2e3-4681-b814-41d1986de7af)

#### view Product of Detail with Dynamic Breadcamp 

![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/9eda3f30-3a12-4401-952d-3a694b097e77)

#### Cart Page 
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/23b08511-0e6e-41c1-8b9d-7f72b5b65952)

#### Alert IF Item Quantity isn't available in stock 
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/3a129a57-2df3-440a-9b1c-5c43348027f5)


#### Favourite Products
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/a2debeef-585c-4bc5-bd39-4c6680deee7d)


#### Delete Favourite Products
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/092ce378-7db0-4119-8130-65f5330cd689)


#### Search Favourite Products with product Name
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/39e4d3f6-425c-444f-b316-5b2a2b587434)

#### Order a Product
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/a958670a-8d89-411c-af41-901d933920d7)

#### Track Orders
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/8501280b-dbf8-4fdc-abf3-5afb003ac251)


#### Check order Details
![image](https://github.com/Abdullah-moiz/nextjs-ecommerce/assets/90745903/139f02be-806f-4d8c-8cba-51948682277a)






    
