<p align="center">
    <br>
    <img src="banner.png" width="500"/>
    <br>
</p>

[[Readme ENG](README.md)][[Readme ZH](README_ch.md)]

CuteGPT是[复旦大学知识工场实验室](http://kw.fudan.edu.cn/)推出的一个支持中英双语的开源对话语言模型，基于Llama模型结构进行改进和扩展，规模为13B（130亿）参数，可以在单张3090显卡上进行int8精度的推理。CuteGPT基于Llama模型结构，修改了中文词表并进行了大量的预训练，提高了对中文的理解能力，后续经过对话指令微调，提升了模型对指令的理解能力。

在KW-CuteGPT-7b版本的基础上，KW-CuteGPT-13b的知识准确性、对复杂指令的理解、长文本理解能力、推理能力、忠实问答等能力均有提升。目前KW-CuteGPT-13b版本模型在部分测评任务中能够超越绝大多数同量级模型。

## 开放参数
我们开源了以下版本的参数：

| Huggingface                       | 描述                       |
| --------------------------------- | -------------------------- |
| XuYipei/kw-cutegpt-13b-base       | 基于扩充中文词表进行预训练 |
| XuYipei/kw-cutegpt-13b-ift        | 全量参数指令微调           |
| Abbey4799/kw-cutegpt-13b-ift-lora | 基于lora指令微调           |

## 评测结果
我们对部分典型的中英文数据集进行了评估，以下为CuteGPT模型在[C-eval](https://github.com/SJTU-LIT/ceval)和[XieZhi](https://github.com/MikeGu721/XiezhiBenchmark)上的评测结果。

### C-eval [[Code](https://github.com/SJTU-LIT/ceval)]

#### Zero-shot

| Model                          | STEM           | Social Science | Humanities     | Other          | Average        |
| ------------------------------ | -------------- | -------------- | -------------- | -------------- | -------------- |
| GPT-4                          | 65.2           | 74.7           | 62.5           | 64.7           | 66.4           |
| ChatGPT                        | 49             | 58             | 48.8           | 50.4           | 51             |
| Claude-v1.3                    | 48.5           | 58.6           | 47.3           | 50.1           | 50.5           |
| Bloomz-mt-176B                 | 39.1           | 53             | 47.7           | 42.7           | 44.3           |
| GLM-130B                       | 36.7           | 55.8           | 47.7           | 43             | 44             |
| Claude-instant-v1.0            | 38.6           | 47.6           | 39.5           | 39             | 40.6           |
| ChatGLM-6B                     | 33.3           | 48.3           | 41.3           | 38             | 38.9           |
| LLaMA-65B                      | 32.6           | 41.2           | 34.1           | 33             | 34.7           |
| **CuteGPT-13B-ift-lora** | **30.9** | **39.3** | **37.9** | **32.4** | **34.3** |
| MOSS                           | 31.6           | 37             | 33.4           | 32.1           | 33.1           |
| Chinese-Alpaca-13B             | 27.4           | 39.2           | 32.5           | 28             | 30.9           |
| Chinese-LLaMA-13B              | 28.8           | 32.9           | 29.7           | 28             | 29.6           |

#### Five-shot

| Model                          | STEM           | Social Science | Humanities     | Other          | Average        |
| ------------------------------ | -------------- | -------------- | -------------- | -------------- | -------------- |
| GPT-4                          | 67.1           | 77.6           | 64.5           | 67.8           | 68.7           |
| ChatGPT                        | 52.9           | 61.8           | 50.9           | 53.6           | 54.4           |
| Claude-v1.3                    | 51.9           | 61.7           | 52.1           | 53.7           | 54.2           |
| Claude-instant-v1.0            | 43.1           | 53.8           | 44.2           | 45.4           | 45.9           |
| GLM-130B                       | 34.8           | 48.7           | 43.3           | 39.8           | 40.3           |
| Bloomz-mt-176B                 | 35.3           | 45.1           | 40.5           | 38.5           | 39             |
| LLaMA-65B                      | 37.8           | 45.6           | 36.1           | 37.1           | 38.8           |
| **CuteGPT-13B-ift-lora** | **33.3** | **43.1** | **40.4** | **35.5** | **37.1** |
| **CuteGPT-13B-base**     | **33.3** | **42**   | **39.7** | **33.8** | **36.4** |
| ChatGLM-6B                     | 30.4           | 39.6           | 37.4           | 34.5           | 34.5           |
| Chinese LLaMA-13B              | 31.6           | 37.2           | 33.6           | 32.8           | 33.3           |
| MOSS                           | 28.6           | 36.8           | 31             | 30.3           | 31.1           |
| Chinese Alpaca-13B             | 26             | 27.2           | 27.8           | 26.4           | 26.7           |

#### C-eval Hard

| Model                          | Zero-shot      | Five-shot      |
| ------------------------------ | -------------- | -------------- |
| GPT-4                          | 53.3           | 54.9           |
| Claude-v1.3                    | 37.6           | 39             |
| ChatGPT                        | 36.7           | 41.4           |
| Claude-instant-v1.0            | 32.1           | 35.5           |
| Bloomz-mt                      | 30.8           | 30.4           |
| GLM-130B                       | 30.7           | 30.3           |
| LLaMA-65B                      | 29.8           | 31.7           |
| ChatGLM-6B                     | 29.2           | 23.1           |
| **CuteGPT-13b-ift-lora** | **28.4** | **28.9** |
| MOSS                           | 28.4           | 24             |
| Chinese-LLaMA-13B              | 27.5           | 27.3           |
| Chinese-Alpaca-13B             | 24.4           | 27.1           |

### XieZhi [[Code](https://github.com/MikeGu721/XiezhiBenchmark)]

[复旦大学肖仰华团队——獬豸（Xiezhi）](https://arxiv.org/abs/2306.05783)是一套针对语言模型（LM）的领域评估Benchmark。它由249587道多选题组成，涉及516个不同的学科和三个不同的学科粒度。学科分类和所有的一级学科如下图所示，括号内表示的是每个一级学科下二级学科的个数。

| Models                         | MMLU            | MMLU            | MMLU       | C-Eval          | C-Eval          | C-Eval          | M3KE            | Xiezhi-Spec.-Chinese | Xiezhi-Spec.-Chinese | Xiezhi-Spec.-Chinese | Xiezhi-Inter.-Chinese | Xiezhi-Inter.-Chinese | Xiezhi-Inter.-Chinese | Xiezhi-Spec.-English`` | Xiezhi-Spec.-English`` | Xiezhi-Spec.-English`` | Xiezhi-Inter.-English | Xiezhi-Inter.-English | Xiezhi-Inter.-English |
| ------------------------------ | --------------- | --------------- | ---------- | --------------- | --------------- | --------------- | --------------- | -------------------- | -------------------- | -------------------- | --------------------- | --------------------- | --------------------- | ---------------------- | ---------------------- | ---------------------- | --------------------- | --------------------- | --------------------- |
|                                | 0-shot          | 1-shot          | 3-shot     | 0-shot          | 1-shot          | 3-shot          | 0-shot          | 0-shot               | 1-shot               | 3-shot               | 0-shot                | 1-shot                | 3-shot                | 0-shot                 | 1-shot                 | 3-shot                 | 0-shot                | 1-shot                | 3-shot                |
| Random-Guess                   | 0.089           | 0.089           | 0.089      | 0.089           | 0.089           | 0.089           | 0.089           | 0.089                | 0.089                | 0.089                | 0.089                 | 0.089                 | 0.089                 | 0.089                  | 0.089                  | 0.089                  | 0.089                 | 0.089                 | 0.089                 |
| <100B                          |                 |                 |            |                 |                 |                 |                 |                      |                      |                      |                       |                       |                       |                        |                        |                        |                       |                       |                       |
| **CuteGPT-13B-ift-lora** | **0.154** | 0.092           | 0.051      | *0.143*       | **0.191** | **0.157** | 0.103           | *0.17*             | **0.204**      | 0.143                | *0.18*              | *0.221*             | **0.202**       | **0.141**        | **0.189**        | **0.209**        | *0.174*              | **0.215**       | **0.255**       |
| **CuteGPT-7B-ift**                 | *0.146*       | *0.105*        | **0.125** | 0.122           | 0.117           | *0.136*        | *0.121*        | 0.123                | 0.158                | *0.166*             | 0.150                 | 0.177                 | *0.188*              | *0.132*               | *0.127*               | *0.124*               | **0.200**            | *0.159*              | *0.182*              |
| chatglm2-6B                    | 0.063           | 0.082           | 0.111      | **0.145** | *0.143*       | 0.105           | **0.182** | **0.242**      | *0.191*            | **0.22**       | **0.259**       | **0.222**       | 0.165                 | 0.106                  | 0.095                  | 0.099                  | 0.096                 | 0.096                 | 0.112                 |
| chatglm-6B                     | 0.099           | **0.109** | *0.112*   | 0.084           | 0.074           | 0.114           | 0.115           | 0.082                | 0.097                | 0.147                | 0.104                 | 0.111                 | 0.144                 | 0.106                  | 0.12                   | *0.124*              | 0.099                 | 0.079                 | 0.097                 |
| doctorglm-6B                   | 0.093           | 0.076           | 0.065      | 0.037           | 0.085           | 0.051           | 0.038           | 0.062                | 0.068                | 0.044                | 0.047                 | 0.056                 | 0.043                 | 0.069                  | 0.053                  | 0.043                  | 0.106                 | 0.059                 | 0.059                 |
| moss-base-16B                  | 0.072           | 0.05            | 0.062      | 0.115           | 0.048           | 0.052           | 0.099           | 0.105                | 0.051                | 0.059                | 0.123                 | 0.054                 | 0.058                 | 0.124                  | 0.077                  | 0.08                   | 0.121                 | 0.058                 | 0.063                 |
| moss-sft-16B                   | 0.064           | 0.065           | 0.051      | 0.063           | 0.062           | 0.072           | 0.075           | 0.072                | 0.067                | 0.068                | 0.073                 | 0.081                 | 0.066                 | 0.071                  | 0.07                   | 0.059                  | 0.074                 | 0.084                 | 0.075                 |
| >100B                          |                 |                 |            |                 |                 |                 |                 |                      |                      |                      |                       |                       |                       |                        |                        |                        |                       |                       |                       |
| ChatGPT                        | 0.24            | 0.298           | 0.371      | 0.286           | 0.289           | 0.36            | 0.29            | 0.218                | 0.352                | 0.414                | 0.266                 | 0.418                 | 0.487                 | 0.217                  | 0.361                  | 0.428                  | 0.305                 | 0.452                 | 0.517                 |
| GPT-4                          | 0.402           | 0.415           | 0.517      | 0.413           | 0.41            | 0.486           | 0.404           | 0.392                | 0.429                | 0.49                 | 0.453                 | 0.496                 | 0.565                 | 0.396                  | 0.434                  | 0.495                  | 0.463                 | 0.506                 | 0.576                 |

#### 选项设置

所有被测试的LLM都需要从50个选项中选择最适合的答案。每道题除了正确答案外，还设置了3个易混淆的选项，另外还设置46个完全无关的选项，这些选项是从所有题目的所有选项中随机抽取的。值得注意的是，我们已经预先删除了要求选择错误答案的问题。

#### 衡量标准

利用了每个模型生成特定答案的概率来计算每个模型选择每个选项的概率，然后根据概率对所有选项进行相应的排名，并使用了MRR作为衡量标准。MRR表示模型会将正确答案平均排在什么位置。MRR值接近1则表示模型更有能力将正确答案放在排名的前面；而如果MRR值接近0，则模型倾向于将正确答案放在最后。

## CuteGPT使用示例

以下的使用示例来自我们的工作[CELLO](https://arxiv.org/abs/2309.09150)，"Can Large Language Models Understand Real-World Complex Instructions?"。该工作旨在研究大语言模型理解复杂指令的能力，敬请关注。

| Category           | Instruction                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | kw-cutegpt-13b-ift                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | kw-cutegpt-13b-ift-lora                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | kw-cutegpt-7b-ift                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| ------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 要求细致的头脑风暴 | ['请推荐五本中国古典小说，包含其作品名以及作者名，以表格的形式给出',<br>'再在表格中加一列作品的时间呢？']                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | ['\| 作品名 \| 作者名 \|<br>\| --- \| --- \|<br>\| 《红楼梦》 \| 曹雪芹 \|<br>\| 《西游记》 \| 吴承恩 \|<br>\| 《水浒传》 \| 施耐庵 \|<br>\| 《三国演义》 \| 罗贯中 \|<br>\| 《聊斋志异》 \| 蒲松龄 \|',<br>'\| 作品名 \| 作者名 \| 时间 \|<br>\| --- \| --- \| --- \|<br>\| 《红楼梦》 \| 曹雪芹 \| 清代 \|<br>\| 《西游记》 \| 吴承恩 \| 明代 \|<br>\| 《水浒传》 \| 施耐庵 \| 元代 \|<br>\| 《三国演义》 \| 罗贯中 \| 明代 \|<br>\| 《聊斋志异》 \| 蒲松龄 \| 清代 \|'<br>]                                                                                                                                                                                                            | ['\| 作品名 \| 作者名 \|<br>\| --- \| --- \|<br>\| 《三国演义》 \| 罗贯中 \|<br>\| 《水浒传》 \| 施耐庵 \|<br>\| 《红楼梦》 \| 曹雪芹、高鹗 \|<br>\| 《西游记》 \| 吴承恩 \|<br>\| 《儒林外史》 \| 吴敬梓 \|',<br>'\| 作品名 \| 作者名 \| 时间 \|<br>\| --- \| --- \| --- \|<br>\| 《三国演义》 \| 罗贯中 \| 元末明初 \|<br>\| 《水浒传》 \| 施耐庵 \| 元末明初 \|<br>\| 《红楼梦》 \| 曹雪芹、高鹗 \| 清代中期 \|<br>\| 《西游记》 \| 吴承恩 \| 明代 \|<br>\| 《儒林外史》 \| 吴敬梓 \| 清代中期 \|<br>]                                                                                                                                                                                                        | ['以下是五本中国古典小说的名称、作者和简介：<br>\| 作品名 \| 作者 \| 简介 \|<br>\| --- \| --- \| --- \|<br>\| 《红楼梦》 \| 曹雪芹 \| 一部经典的古典小说，描写了清朝贵族家庭的兴衰和人性的复杂性。 \|<br>\| 《西游记》 \| 吴承恩 \| 这是一部神话小说，讲述了神魔小说中的经典故事，包括龙宫、火焰山等。 \|<br>\| 《水浒传》 \| 施耐庵 \| 这是一部武侠小说，主要讲述了梁山伯与祝英台之间的爱情故事，并描绘了众多英雄人物。 \|<br>\| 《三国演义》 \| 罗贯中 \| 这是一部历史小说，主要讲述了三国时期的战争和英雄人物，如刘备、曹操、孙权等。 \|<br>\| 《金瓶梅词》 \| 兰陵笑笑生 \| 这是一部诗集，主要描写了明朝时期一个富贵人家的日常生活和情感纠葛。 \|',<br>'好的，以下是五本中国古典小说的时间信息：<br>\| 作品名 \| 作者 \| 时间 \|<br>\| --- \| --- \| --- \|<br>\| 《红楼梦》 \| 曹雪芹 \| 18世纪中期 \|<br>\| 《西游记》 \| 吴承恩 \| 16世纪中期 \|<br>\| 《水浒传》 \| 吴承恩 \| 1540年代 \|<br>\| 《三国演义》 \| 罗贯中 \| 17世纪中期 \|<br>\| 《金瓶梅词》 \| 兰陵笑笑生 \| 18世纪中期 \|<br>\| 《三国演义》 \| 罗贯中 \| 16世纪中期 \|<br>\| 《水浒传》 \| 吴承恩 \| 1540年代 \|<br>\| 《三国演义》 \| 罗贯中 \| 17世纪中期 \|<br>\| 《金瓶梅词》 \| 兰陵笑笑生 \| 18世纪中期 \|<br>\| 《三国演义》 \| 罗贯中 \| 16世纪中期 \|<br>\| 《水浒传》 \| 吴承恩 \| 1540年代 \|<br>\| 《三国演义》 \| 罗贯中 \| 17世纪中期 \|<br>\| 《金瓶梅词》 \| 兰陵笑笑生 \| 18世纪中期 \|'] |
| 规划               | 你是一个知识图谱访问代理，你的任务是编写Python代码，使用内置的Python函数和下面给出的函数来获取用户查询相关的信息：<br>1. get_entity_info(entity_aliases)：获取一个实体的百科信息。返回'result'（实体信息或None）和'message'（描述函数调用和结果）。<br>2. find_entity_or_value(entity_aliases, relation_aliases)：找到实体或值以回答事实查询。返回'result'（实体名列表或属性值或None）和'message'（描述函数调用和结果）。<br>3. find_relationship(entity1_aliases, entity2_aliases)：预测两个实体之间的关系。返回'result'（关系或None）和'message'（描述函数调用和结果）。<br>===<br>请遵循以下规则：<br>1. 你的工作是获取相关知识，而不是直接回答查询。<br>2. 只使用内置的Python函数和提供的函数。<br>3. 在调用函数时，对实体和关系的别名进行释义和列举候选，按别名频率排序。<br>4. 在使用find_entity_or_value时，使用清晰的关系。对于模糊或广泛的关系查询，使用get_entity_info。<br>5. 通过富有逻辑的代码处理多步或嵌套的查询。<br>6. 以JSON格式响应。<br>7. 你需要一步一步思考并给出三个部分的结果：need_knowledge, thought, code。首先，你需要判断该问题是否需要知识。若是，你需要先给出一个想法，规划如何完成该查询。然后，你需要将想法转化为可执行的代码。<br>8. 所有函数调用的'messages'都记录在名为'messages'的字符串中，这是search()的返回值。<br>9. 在'messages'字符串中添加必要的解释。<br>输出格式：<br>{<br>    "need_knowledge": "<是或否>",<br>    "thought": "<你的思考过程>",<br>    "code": "def search():\n\tmessages = ''\n\t<你的代码>\n\treturn messages\n",<br>}<br>===示例===<br>Input："提出进化论的科学家是谁？"<br>Output：<br>{<br>    "need_knowledge": "是",<br>    "thought": "这个问题想问的是谁提出了进化论，我需要查询进化论的提出者是谁。'提出者'关系可能的表达方式有'提出'、'提出者'、'发现'。",<br>    "code": "def search():\n\tmessages = ''\n\tproposer, msg = find_entity_or_value(entity_aliases = ['进化论'], relation_aliases = ['提出', '提出者', '发现'])\n\tmessages += msg\n\treturn messages\n"<br>}<br>2.<br>Input："有哪些科幻小说和《三体》是同一个作者？"<br>Output：<br>{<br>    'need_knowledge': 'yes', <br>    'thought': "这个问题想要知道和《三体》是同一个作者的科幻小说都有哪些。首先，我需要找到《三体》的作者，这个关系可能被表达为'作者'、'创作'、'写作'。然后，我需要找到这个作者创作的其他科幻小说，这个关系可能被表达为'作品'、'创作'、'写作'。", <br>    'code': "def search():\n\tmessages = ''\n\tauthor, msg = find_entity_or_value(entity_aliases = ['三体'], relation_aliases = ['作者', '创作', '写作'])\n\tmessages += msg\n\tif author:\n\t\tworks, msg = find_entity_or_value(entity_aliases = author, relation_aliases = ['作品', '创作', '写作'])\n\t\tmessages += msg\n\treturn messages\n", <br>}<br>===<br>输入: 《择天记》的男主角是谁？他还有什么代表作品？                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | {<br>    "need_knowledge": "是",<br>    "thought": "这个问题想问的是《择天记》的男主角是谁，以及他有哪些代表作品。'男主角'关系可能的表达方式有'主角'、'男主角'、'主演'。'代表作品'关系可能的表达方式有'作品'、'代表作品'、'作品名称'。",<br>    "code": "def search():<br>        messages = ''<br>        main_character, msg = find_entity_or_value(entity_aliases = ['择天记'], relation_aliases = ['男主角', '主角', '主演'])       <br>        messages += msg <br>        representative_works, msg = find_entity_or_value(entity_aliases = main_character, relation_aliases = ['代表作品', '作品', '代表作品', '作品名称'])<br>        messages += msg <br>        return messages <br>",<br>} | {<br>    "need_knowledge": "是",<br>    "thought": "这个问题想问的是《择天记》的男主角是谁，以及他有什么代表作品。首先，我需要找到《择天记》的男主角，这个关系可能被表达 为'主角'、'主演'、'演员'等。其次，我还需要找到他的代表作品，这个关系可能被表达为'作品'、'创作'、'写作'等。",<br>    "code": "def search():<br>        messages = ''<br>        actor, msg = find_entity_or_value(entity_aliases = ['择天记'], relation_aliases = ['主角', '主演', '演员'])<br>        messages += msg <br>        if actor:<br>                works, msg = find_entity_or_value(entity_aliases = actor, relation_aliases = ['作品', '创作', '写作'])<br>                messages += msg <br>        return messages <br>"<br>} | {<br>    "need_knowledge": "no",<br>    "thought": "这个问题想要了解《择天记》的男主角是谁，以及他有没有其他的代表作品。首先，我需要找到《择天记》的男主角，这个关系可能被表达为'男主角'、'主演'、'主角'。然后，我需要找到这个男主角的其他代表作品，这个关系可能被表达为'作品'、'创作'、'写作'。", <br>    'code': "def search():<br>        messages = ''<br>        author, msg = find_entity_or_value(entity_aliases = ['择天记'], relation_aliases = ['男主角', '主演', '主角'])<br>        messages += msg <br>        if author:<br>                works, msg = find_entity_or_value(entity_aliases = author, relation_aliases = ['作品', '创作', '写作'])<br>                messages += msg <br>        return messages <br>", <br>}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| 复杂抽取           | 从句子中提取公司的基本信息。需要提取公司名称、成立时间、公司类型、资产总额、经营总收入、主要销售区域、主要产品等信息。其中的输出格式为输出格式为字典，包含以下键值对：<br>{<br>    "公司名称": "",<br>    "成立时间": "",<br>    "公司类型": "",<br>    "资产总额": "",<br>    "经营总收入": "",<br>    "主要销售区域": "",<br>    "主要产品": ""<br>}<br><br>北京京煤集团有限责任公司是按现代企业制度于2001年初组建的国有独资大型煤炭企业集团。现拥有资产总额149亿元，2008年实现经营总收入93亿元。它所产无烟煤畅销京津、华北、东北、华南及亚、欧、北美、南美四大洲，是中国最大的优质无烟煤生产和出口基地之一。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | {<br>    "公司名称": "北京京煤集团有限责任公司",<br>    "成立时间": "2001年",<br>    "公司类型": "国有企业",<br>    "资产总额": "149亿元",<br>    "经营总收入": "93亿元",<br>    "主要销售区域": "京津、华北、东北、华南及亚、欧、北美、南美四大洲",<br>    "主要产品": "无烟煤"<br>}                                                                                                                                                                                                                                                                                                                                                                                                                             | {<br>    "公司名称": "北京京煤集团有限责任公司",<br>    "成立时间": "2001年初",<br>    "公司类型": "国有独资大型煤炭企业集团",<br>    "资产总额": "149亿元",<br>    "经营总收入": "93亿元",<br>    "主要销售区域": "京津、华北、东北、华南及亚、欧、北美、南美四大洲",<br>    "主要产品": "中国最大的优质无烟煤生产和出口基地之一"<br>}                                                                                                                                                                                                                                                                                                                                                                                                  | {<br>    "公司名称": "北京京煤集团有限责任公司",<br>    "成立时间": "2001年初",<br>    "公司类型": "国有独资大型煤炭企业集团",<br>    "资产总额": "149亿元",<br>    "经营总收入": "93亿元",<br>    "主要销售区域": "京津、华北、东北、华南及亚、欧、北美、南美",<br>    "主要产品": "无烟煤"<br>}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| 长文本摘要         | 对话内容:说话人 1 :喂。说话人 2 :诶，胡老师。说话人 1 :哎，你说。说话人 2 :哎，不是还没下班没有是这样的，就是有有有这么一个需求，呃，我看了一下，之前呢一九年的时候呢，好像当时他们对接的是那个里为准还是准哥，他不是走了吗？他是这样的，就是呃，就是根据那个市里面和区里面的要求呢，就是像这种城中村啊，村股份公司，他的银行开了户。呃，村股份公司。说话人 1 :哦哦。说话人 2 :就是一批嘛，就一批客户。那要求呢，就是说他他的那个账户是要受到那个盐田，就是各个区啊，这个国资局集体办的这么一个，呃，应该叫监督吧，就是不叫监管，然后就是说他们需要能看到这些账户的这个流水啊。然后呢，现在是这样的，现在就是说，呃，他们之前呢我们已经对接过一个，就是他们已经开发好了一个系统，然后呢我们也我们也在里面，那相当于相当于他现在就是说需要这种比如说。说话人 1 :政府先等一下是谁开发谁开发了什么系统？说话人 2 :呃，说的第三方。说话人 1 :公司，呃。说话人 2 :不就是第三方公司啊，就政府找到第三方公司呢，已经开发了一个这种叫做呃，城中村的这种账户监管系统，那相当于相当于就是说他这个系统呢，要让我们银行要给一个接口，能够让他们看到，呃，他在我们就是纯就是那个村股份公司啊，在我们银行开了这些户的这个明细和流水啊，那么其他其他的银行呢，都已经全部做了。然后之前呢，我们以为我们银行是已经接上了系统，但是呢？到到昨天才发现其实我们那个系统没有开接口。然后呢，之前他们是那个第三方公司，他们有做一个那个呃，引起之年的那个测试报告啊，是已经有现成的，那现在就是我。我我我就想问一下，第一个我做银企直联，我是不是可以实现这个功能？说话人 1 :嗯，他是这样的啊，我们。我目前对你这个还有一点没太明白的事，因为正常情况下，我们跟客户做银企直联，对吧？是客户那边，就比如说，呃，我比如说你的客户。是这个村存股份公司，那他要来跟我银行直连，那我银行去跟他就存股份这边比如说自己有一个系统，那我们银行去跟他那个系统对接，我为什么要对接呢？是因为他要抓取他在我银行的账户的数据，比如说查询，比如说支付，比如说代发，那么说我们跟这个公司直接对接，但是呢，你现在的诉求是因为这个公司是受到了它的外部或者是国家的什么单位的一个管理的要求，需要那那个单位对他的账号去进行查询的话。那我就不知道你要要怎么接呢？或者是其他银行怎么接的呢？说话人 2 :他。我问了一下那个第三方，他说其他银行呢？有两种方式，一个就是通过银企直联，第二个呢是走专线。说话人 1 :嗯。对，嗯嗯这这这两个方式的话，只是说客户的网络去怎么通直连的话有两种，一种你说的是专线，一种是公网吗？那我们目前走的都是公网公网去做这个事情，这是网络的问题，跟业务没有关系。说话人 2 :哦哦，明白。说话人 1 :嗯嗯嗯。说话人 2 :呃，我想想这个就是其实他们的要求需求就是说那个政府通过他们的那那个系统能够呢去看到这些，这些账户在我们银行的这个流水就是就是这么一个反正就是他们的需求点，就是就是就是在这就是在这个地方。说话人 1 :如那如果是这样的话呢，就需要我们银行的这，这可能就不是说单纯的我们跟这个客户去做银企直联，可能是需要我们银行的系统要跟你说的那个第三方平台的系统去打通，就比如说我们之前做过一个客户，也是比如说那些物业公司，然后呢他们是受住建局的要求要来。说话人 2 :哦对其实可能有有点有点像有点像。说话人 1 :是由住建局的要求来我银行来做监管，那首先肯定是我，呃，那需要我那那住建局要查到这些可账户的一些相关的情况的话，或者是，呃。这些客户要去逐渐地柜局的系统里面取一些相关的数据，数据的时候才能做。支付的时候需要我们行去跟住建局的系统去打通才可以。这个并不仅仅是简单的直连能解决的问题，直连能解决的只是客户账户账户层面的问题。你这个可能是不仅基于账户还有一些业务逻辑在里面。说话人 2 :哦，我明白，哎，你看这样行不行，呃，如果你现在还不没有那么忙的话，我，我拉个群，我把那个第三方的公司那个人拉进来，我们用那个微信，那个微信，那个电话，我们一起那个，呃，沟通一下。说话人 1 :你你你组一个线上会议吧就是用同性会，因为要用。说话人 2 :手机腾讯。说话人 1 :会议是吧？微信的话老友进来电话的话会打断。说话人 2 :哦哦，我明白你意思我明白你意思。说话人 1 :有个会，我们线上沟通一下。说话人 2 :吧，行行好，我跟他说一下啊，嗯，好麻烦你麻烦你啊，呃，你，你，你，你如果现在可以，我就现在。说话人 1 :嗯，有什么还是明天什么人我最好。说话人 2 :是对方，是吧？说话人 1 :要沟通的那个人的业务，或者是。嗯，技术你但有技术不行，那还搞不懂业务吗？你技术只是跟他。说话人 2 :都是这些，他都是在这都是由它在做做那个对接。说话人 1 :那客户这边就不需要人进进人吗？说话人 2 :呃，客户不需要它对它相当于就是他就是政府委托的这个平台公司啊，就是运运他们叫做运维公司吗？说话人 1 :嗯，那你跟他约明天早上吧。说话人 2 :好，明天早上大概几点钟你方便。说话人 1 :八点半以后上班都可以。说话人 2 :行好行，那我知道了啊。说话人 1 :最好是好就是要要要关键的人在要参会。说话人 2 :务农，我明白我明白，我明白。说话人 1 :点在那里，要不然沟通的不。说话人 2 :透彻啊，我明白我明白，我明白。说话人 1 :啊嗯嗯。说话人 2 :好吧，好好行好。说话人 1 :好好，嗯，好好。说话人 2 :拜拜，拜拜。说话人 1 :嗯嗯。<br>请根据这一会议录音，分点总结会议的结论和说话人的代办事项。 | 会议结论：<br>1. 需要与第三方公司沟通，以确定是否可以通过银企直连或专线的方式实现客户的需求。<br>2. 如果需要通过银企直连，需要考虑如何与住建局系统进行打通。<br>3. 如果需要通过专线，需要考虑如何与第三方公司的系统进行打通。<br>4. 需要安排一个线上会议，以便与第三方公司进行沟通和讨论。<br>说话人的代办事项：<br>1. 与第三方公司联系并邀请其加入微信群，以便进行线上沟通和讨论。<br>2. 与第三方公司确认是否可以通过银企直连或专线的方式实现客户的需求。<br>3. 与第三方公司讨论如何与住建局系统进行打通。<br>4. 与第三方公司讨论如何与第三方公司的系统进行打通。<br>5. 与第三方公司商讨具体的沟通时间和方式。                                                                                           | 1. 客户需要与第三方平台公司合作，以满足其监管部门的需求；<br>2. 银行需要与第三方平台公司建立联系，以便为客户提供服务；<br>3. 银行需要了解客户的具体需求，并制定相应的解决方案；<br>4. 银行需要安排相关人员参加线上会议，以便更好地理解客户的需求。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 会议的结论是：<br>1. 确认了与客户的沟通渠道，包括在线会议、微信等；<br>2. 确定了客户的需求，包括了解银行的系统对接情况、提供技术支持等；<br>3. 安排了明天早上与客户面谈，以确保客户理解并同意银行的方案。<br>说话人的任务清单：<br>1. 确认客户的沟通渠道，包括在线会议、微信等；<br>2. 了解客户的需求，包括了解银行的系统对接情况、提供技术支持等；<br>3. 安排明天早上与客户面谈，以确保客户理解并同意银行的方案。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| 封闭式问答         | 参考这一篇文章里与问题相关的以下3段文本，然后回答后面的问题：<br>1:现模型大小的优化，再通过 OpenVINO™的量 化工具和推理引擎，对模型实现 INT8 量化，从而实现模型压缩，以降低模型推理所需的计 算资源和内存带宽，提高模型的推理性能。通过使用中兴 Adlik+第三代英特尔®至强®可扩 展处理器+ OpenVINO™工具套件的组合，可使已完成训练的高精度 AI 模型转换成参数较 小、结构简单、精度基本不下降的 AI 小模型，其性能与大模型接近，模型数据吞吐量更高， 从而实现在不增加 GPU 硬件，大幅减少部署成本的情况下，直接使用 CPU 服务器即可满 足模型的日常推理需求，成功实现降本增效，并使得模型更易部署在算力有限的场景下，比 如自动驾驶车端场景。我们认为此解决方案能够实现 AI 模型推理的降本增效，适用各垂直 领域的 AI 小模型有望加速落地，充分满足不同场景需求。 Adlik 是用于将深度学习模型从训练完成到部署到特定硬件，提供应用服务的 <br>2:，充分满足不同场景需求。 Adlik 是用于将深度学习模型从训练完成到部署到特定硬件，提供应用服务的端到端工具链， 其应用目的是为了将模型从研发产 品快速部署到生产应用环境。Adlik 可以和多种推理引 擎协作， 支持多款硬件，提供统一对外推理接口，并提供多种灵活的部署方案。目前谷歌 TensorFLOW，Meta PyTorch 和百度的 PP 飞桨深度学习库都已能够接入 Adlik 架构。随 着 Meta AI SAM 开源图像分割模型的问世，计算机视觉产业或将加速发展。由于 SAM 中 的图像编码器功能必须在 PyTorch 中实现，并需要 GPU 才能进行高效推理，我们认为计 算机视觉产业的发展有望进一步带动对 Meta 深度学习库 PyTorch 以及其他 AI 互联网企业 深度学习库的需求，公司 adlik 软硬整体架构的需求有望提升。 请阅读最后一页免责声明及信息披露 htt <br>3: ##### 图 1：SAM 模型设计包含图像编码器、提示编码器和掩码解码器 资料来源：IDC，信达证券研发中心 ➢谷歌、Meta、百度等深度学习库均已接入中兴 Adlik 架构，长期需求有望持续释放 2022 年 12 月 28 日，公司联合英特尔共同发布《英特尔联手中兴优化深度学习模型推理， 实现降本增效》白皮书，本白皮书深入介绍了中兴通讯主导的开源项目 Adlik 如何与英特尔 OpenVINO 工具结合。为解决购买专用 GPU 硬件会大幅增加部署成本，而且应用范围有 限，灵活度较低的问题，中兴通讯通过硬件创新和软件层面的深度优化，在部分场景中，如 果能够直接使用 CPU 来进行推理，将有助于降低成本，提升灵活度，白皮书指出通过中兴 Adlik 可以对 AI 模型进行自动剪枝、蒸馏，实现模型大小的优化，再通过 OpenVINO™的量 化工具和推理引擎，对模型实现 INT8 量化，从而 <br><br>问题：Adlik是什么，有什么作用？<br>：                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Adlik是一种用于将深度学习模型从训练完成到部署到特定硬件，提供应用服务的端到端工具链，其应用目的是为了将模型从研发产品快速部署到生产应用环境。Adlik可以和多种推理引擎协作，支持多款硬件，提供统一对外推理接口，并提供多种灵活的部署方案。随着Meta AI SAM开源图像分割模型的问世，计算机视觉产业或将加速发展。由于SAM中的图像编码器功能必须在PyTorch中实现，并需要GPU才能进行高效推理，我们认为计算视觉产业的发展有望进一步带动对Meta深度学习库PyTorch以及其他AI互联网企业的深度学习库的需求，公司adlik软硬整体架构的需求有望提升。                                                                                                                                                                                                                  | Adlik是用于将深度学习模型从训练完成到部署到特定硬件，提供应用服务的端到端工具链，其应用目的是为了将模型从研发产品快速部署到生产应用环境。Adlik可以和多种推理引擎协作，支持多款硬件，提供统一对外推理接口，并提供多种灵活的部署方案。目前谷歌 TensorFlow，Meta PyTorch 和百度的 PP 飞桨深度学习库都已能够接入 Adlik 架构。随着 Meta AI SAM 开源图像分割模型的问世，计算机视觉产业或将加速发展。由于 SAM 中的图像编码器功能必须在 PyTorch 中实现，并需要 GPU 才能进行高效推理，我们认为计算机视觉产业的发展有望进一步带动对 Meta 深度学习库 PyTorch 以及其他 AI 互联网企业深度学习库的需求，公司 Adlik 软硬整体架构的需求有望提升。                                                                                                                                        | Adlik是一种基于OpenVINO的智能化AI小模型构建平台，旨在帮助开发者构建高效、低成本、高性能的AI小模型。它可以帮助开发者更快速地开发出具有良好性能和可扩展性的AI小模型，从而实现在不增加硬件资源的情况下，将模型从研发产品快速部署到生产应用环境。Adlik可以与多种推理引擎协作，支持多款硬件，提供统一对外推理接口，并提供多种灵活的部署方案。随着Meta AI SAM的开源图像分割模型问世，计算机视觉产业或将加速发展。由于SAM中的图像编码器功能必须在PyTorch中实现，并需要GPU才能进行高效推理，我们认为计算能力产业的发展有望进一步释放2022年12月28日，公司联合英特尔共同发布《英特尔联手中兴优化深度学习模型推理，实现降本增效》白皮书，本白皮书深入介绍了中兴通讯主导的开源项目Adlik如何与英特尔OpenVINO工具结合。为解决购买专用GPU硬件会大幅增加部署成本，而且应用范围有限制，灵活度较低的问题，中兴通讯通过硬件创新和                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| 长文本关键词总结   | 从下文中抽取得到关键词。<br>\`\`\`<br>2022年电线电缆产品质量国家监督抽查 <br>情况通报 <br> <br>2022年，市场监管总局组织电线电缆产品质量国家监督抽查。现将抽查情况通报如下：<br>一、基本情况 <br>（一）抽查概况。本次抽查检验北京、天津、河北、山西等29个省（区、市）3325家企业生产的3334批次电线电缆，涉及架空绝缘电缆、塑料绝缘控制电缆、挤包绝缘低压电力电缆、挤包绝缘中压电力电缆、额定电压450/750V及以下聚氯乙烯绝缘电线电缆、阻燃聚氯乙烯绝缘电缆等6个品种，分别抽查检验150批次、125批次、1164批次、3批次、1887批次、5批次。共发现93批次产品不合格（详见附件1），抽查不合格率为2.8%，较上次抽查下降0.5个百分点。该产品近3次抽查不合格率分别为5.0%、3.3%、2.8%。<br>（二）跟踪抽查情况。本次跟踪抽查到上次抽查不合格企业62家，其中有3家企业产品仍不合格（详见附件2），另59家企业产品合格。<br>（三）拒检情况。本次抽查中，广东省中山市东凤镇顶尖电器厂违反《中华人民共和国产品质量法》规定，无正当理由拒绝接受监督抽查。（详见附件3）<br>二、抽查结果分析 <br>本次抽查重点对电线电缆的绝缘最薄处厚度、导体电阻、单根垂直燃烧试验、成束阻燃性能、绝缘平均厚度、护套平均厚度等24个项目进行检验。其中，绝缘最薄处厚度、导体电阻、单根垂直燃烧试验、成束阻燃性能为安全项目。除单根垂直燃烧试验、绝缘偏心度外，其余项目均有不合格。发现绝缘老化后断裂伸长率有19批次产品不合格，绝缘最薄处厚度有18批次产品不合格，绝缘老化前断裂伸长率有17批次产品不合格，导体电阻、护套热失重试验、绝缘平均厚度、绝缘老化前抗张强度各有12批次产品不合格，绝缘热收缩有11批次产品不合格，绝缘老化后抗张强度有10批次产品不合格，成束阻燃性能有2批次产品不合格。<br>经技术机构分析，绝缘最薄处厚度等结构尺寸类项目不合格的主要原因是，生产工艺不当，部分企业在生产时模具配置不合适、挤出工艺控制不精确；导体电阻不合格的主要原因是，部分企业拉丝、束丝或绞制过程控制不符合规定；成束阻燃性能不合格的主要原因是，阻燃原材料存在质量问题；绝缘老化前抗张强度、绝缘老化前断裂伸长率、绝缘老化后抗张强度、绝缘老化后断裂伸长率、绝缘热收缩、护套热失重试验等机械性能项目不合格的主要原因是，绝缘和护套的原材料不符合要求，部分企业挤塑、交联等工艺控制水平不过关。 <br>以上抽查主要涉及河北省、浙江省、江苏省、河南省、广东省、山东省、安徽省等产业聚集区企业生产的产品，分别抽查检验784批次、434批次、417批次、241批次、239批次、225批次、210批次，抽查不合格率分别为1.4%、3.2%、3.1%、3.3%、4.6%、1.8%、3.8%。<br>三、有关要求 <br>针对本次产品质量国家监督抽查发现的问题，各有关省级市场监管部门要做好如下工作：<br>（一）强化抽查结果处理。按照《产品质量法》、《产品质量监督抽查管理暂行办法》等规定，做好监督抽查结果处理工作。对监督抽查发现的不合格产品，依法采取查封、扣押等措施，严禁企业出厂销售，采取有效措施控制产品质量安全风险。对不合格企业，尤其是上次抽查不合格企业，进一步明确整改要求，严格督促落实整改措施，及时组织复查。对涉嫌犯罪的，及时移送司法机关。将严重违法失信企业，依法纳入严重违法失信企业名单管理。结果处理情况要及时录入e-CQS系统。总局将强化跟踪督办，视情通报各地处理结果情况。<br>（二）开展质量专项整治。江苏省、浙江省、安徽省、河南省、广东省等生产企业聚集区市场监管部门，要开展专项整治，加大辖区内重点企业监督检查力度，综合运用多种手段，保持质量监管高压态势，严肃处理质量违法行为，提升质量安全水平。<br>（三）督促落实主体责任。将本次监督抽查不合格产品情况通报相关地方政府及部门，采取有力措施，督促不合格产品企业落实产品质量安全主体责任，严格按照标准依法组织生产销售，保障产品质量安全。<br>（四）加强质量技术帮扶。组织有关行业组织和技术机构，帮助企业深入查找原因，提出改进措施和解决方案，促进行业质量水平提高。<br>\`\`\`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 电线电缆;产品质量;国家监督抽查;不合格产品;抽查结果;跟踪抽查;质量专项整治;主体责任;质量技术帮扶                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 抽查;电线电缆;产品质量                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 本文主要讲述了2022年电线电缆产品质量国家监督抽查的情况通报，包括了抽查的基本情况、不合格情况、不合格企业、不合格产品以及相关要求。                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| 自我修正           | ['刘德华于2008年6月注册结婚的太太是谁?',<br>'再想想呢？']                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | ['谢天华',<br>'刘德华于2008年6月注册结婚的太太是朱丽倩。']                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | ['刘德华于2008年6月注册结婚的太太是朱丽倩。',<br>'刘德华于2008年6月注册结婚的太太是朱丽倩。']                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | ['刘德华于2008年6月注册结婚的太太是朱凯婷（Kate Tang），她是一位加拿大籍华裔女子，比刘德华小两岁，于2000年在加拿大多伦多大学获得计算机工程学位。两人相识于刘德华的一次演唱会上，随后开始约会，最终在2006年11月宣布了婚讯。刘德华和朱凯婷婚后育有一子一女，目前居住在加拿大温哥华。',<br> '刘德华于2008年6月注册结婚的太太是朱凯婷（Kate Tang），她是一位加拿大籍华裔女子，比刘德华小两岁，于2000年在加拿大多伦多大学获得计算机工程学位。两人相识于刘德华的一次演唱会上，随后开始约会，最终在2006年11月宣布了婚讯。刘德华和朱凯婷婚后育有一子一女，目前居住在加拿大温哥华。']                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |

## 使用方式

### 安装依赖

```bash
conda create -n cutegpt python=3.7
conda activate cutegpt
pip install -r requirements.txt 
```

### 使用示例

```python
from transformers import LlamaForCausalLM, LlamaTokenizer
from peft import PeftModel
import torch
```

- 推理时的prompt模版

```python
overall_instruction = "你是复旦大学知识工场实验室训练出来的语言模型CuteGPT。给定任务描述，请给出对应请求的回答。\n"
def generate_prompt(query, history, input=None):
    prompt = overall_instruction
    for i, (old_query, response) in enumerate(history):
        # 多轮对话需要跟训练时保持一致
        prompt += "问：{}\n答：\n{}\n".format(old_query, response)
    prompt += "问：{}\n答：\n".format(query)
    return prompt
```

- 推理代码

  可以直接运行以下脚本进行推理，需要两张3090显卡进行推理
  - 全量微调版本
    ```bash
    CUDA_VISIBLE_DEVICES=0,1 python inference_ft.py
    ```
  - LoRA版本
    ```bash
    CUDA_VISIBLE_DEVICES=0,1 python inference_lora.py
    ```

## 微调

### 数据格式

数据以 `.pkl`的形式存储，可以用以下代码查看数据：

```python
import pickle
import random
file = 'data/test/ift_data.pkl'
with open(file, "rb") as f:
    datas = pickle.load(f)
print(len(datas))
print(random.sample(datas,3))
```

数据由二维数组保存，`len(datas)`为样本的数量，`len(data[i])`代表第 `i`个样本的对话轮数，其中每轮对话由 `instruction`、`input`、`output`三个键值构成。示例如下：

```python
[[{'instruction': '请帮我生成一首诗。', 'input': '', 'output': '好的，请给我一些关键词来启发诗歌的创作。'},
  {'instruction': '月亮、海浪、夜晚。',
   'input': '',
   'output': '心中的孤独由天空掩盖，\n夜幕笼罩下，海浪轻扬，\n月光照亮着沙滩，\n让我不再孤单。'}],
 [{'instruction': '根据给定的数据集，训练一个能够对垃圾邮件进行分类的模型。\n提供垃圾邮件和非垃圾邮件两类的数据集。',
   'input': '',
   'output': '要训练一个能...'}]]
```

我们设计了基于td-idf和instruction、output长度的采样策略，提高了指令微调数据的多样性。

### 微调代码

预处理数据，将数据拼接成多轮对话的格式，并编码得到 `input_ids`，存储下来

```bash
python code/convert_data.py \
	--tokenizer XuYipei/kw-cutegpt-13b-base \
	--max_length 2048 \
	--out_data_path data/test/
```

**注意**：如果是基于`XuYipei/kw-cutegpt-13b-ift`继续微调，需要将`tokenizer`换作`XuYipei/kw-cutegpt-13b-ift`，因为后者加了special token

训练模型

```bash
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 deepspeed --master_port 12932 code/finetune.py \
    --save_steps 2000 \
    --max_epoches 4 \
    --save_name llama_lora \
    --model_path XuYipei/kw-cutegpt-13b-base \
    --dataset_type DatasetIds \
    --data_path data/test/llama_ift_data_ids.pkl \
    --max_length 2048 \
    --use_lora \
    --use_flash_attention
```

参数说明

- `model_path`：`base`模型的路径
- `dataset_type`：封装数据的 `dataset`类定义，在 `code/dataset.py`中定义
- `use_flash_attention`：是否使用flash attention加快训练、减少显存消耗
- `use_lora`：是否采用lora微调，如果为否默认全量微调
- `load_lora`：是否读取lora checkpoint继续训练。如果 `load_lora==True`，在 `load_lora_path`中定义lora checkpoint的路径

**注意**：如果是全量微调，我们增加了special token（`<end>`）帮助模型更好地学习多轮对话的范式

具体的 deepspeed 参数（例如 learning rate、batch size）以及lora参数（例如 lora rank）见`code/config.py`

可以直接运行以下指令进行训练：
- 全量微调
    ```
    bash finetune_ft.sh
    ```
- LoRA微调
    ```
    bash finetune_lora.sh
    ```

## 免责声明

[Facebook官方发布的LLaMA模型](https://github.com/facebookresearch/llama) 明确禁止商业用途。本项目开源的模型和代码仅用于学术应用。我们正在并行地训练商业版本的同等甚至更优的模型，以提供更高质量和更广泛适用性的解决方案。

本项目生成的内容可能受到多种因素的影响，如模型计算、随机性和量化精度损失等，因此我们无法对其准确性作出保证。我们郑重声明，对于使用本项目生成的任何内容所引发的一切后果，本项目概不负责。对于因使用本项目相关资源和输出结果而可能产生的任何损失，本项目不承担任何法律责任。对于基于用户不良诱导得出的不恰当言论，用户自行承担全部责任。

## 引用

```
@misc{CuteGPT,
  author = {Jiaqing Liang, Qianyu He, Yipei Xu, Yikai Zhang, Yuncheng Huang, Wenhao Huang, Xintao Wang, Lida Chen, Haixia Han, Jie Shi, Tinghui Zhu, Yidan Xu, Shisong Chen, Zhouhong Gu, Yanghua Xiao},
  title = {CuteGPT: Towards a Useful Chinese Large Language Model},
  year = {2023},
  publisher = {GitHub},
  journal = {GitHub repository},
  howpublished = {\url{https://github.com/Abbey4799/cuteGPT}},
}
```
