
# Task Tracker API with SignalR and ASP.NET Web Framework

## Overview

This project is a Task Tracker application built using SignalR for real-time updates, ASP.NET Web Framework for the backend, and Angular for the frontend. The application allows users to create, update, delete, and track tasks in real-time.

## Angular Project
https://github.com/AJAY2-R/TaskTracker

## Features

- Real-time task updates using SignalR
- RESTful API endpoints for task management
- User authentication and authorization
- CRUD operations for tasks
- Angular frontend for user interaction

## Prerequisites

Before running this application, ensure you have the following installed:

- [.NET SDK](https://dotnet.microsoft.com/download)
- [Node.js](https://nodejs.org/en/)
- [Angular CLI](https://angular.io/cli)

## Getting Started

1. Clone this repository:

```bash
git clone <repository-url>
```

2. Navigate to the backend directory:

```bash
cd backend
```

3. Install dependencies and run the backend server:

```bash
dotnet restore
dotnet run
```

4. Navigate to the frontend directory:

```bash
cd ../frontend
```

5. Install dependencies and run the Angular development server:

```bash
npm install
ng serve
```


## Technologies Used

- ASP.NET Web Framework
- SignalR
- Angular
- Entity Framework Core
- SQL Server (or your preferred database)

