---
layout: default
group: "navigation"
title: Code of Conduct
permalink: /conduct/
order: 6
---

TL;DR. ACM@UC is dedicated to a harassment-free experience for everyone.

# Code of Conduct
In addition to the University of [Cincinnati’s Student Code of Conduct](https://www.uc.edu/conduct/Code_of_Conduct.html), ACM@UC has its own code of conduct.

ACM@UC is dedicated to providing a harassment-free community experience for everyone regardless of gender, gender identity and expression, sexual orientation, disability, physical appearance, body size, race, ethnicity, age, religion, or computing experience or lack thereof. We do not tolerate harassment of community participants in any form. Participants violating these rules may be sanctioned or expelled from the community at the discretion of the organization executives.

Harassment includes, but is not limited to:

* Verbal comments that reinforce social structures of inequality related to gender, gender identity and expression, sexual orientation, disability, physical appearance, body size, race, age, or religion
* Sexual images in public spaces
* Deliberate intimidation, stalking, or following
* Inappropriate photography or recording
* Sustained disruption of talks or other events
* Inappropriate physical contact
* Unwelcome sexual attention
* Advocating for, or encouraging, any of the above behaviour

## Etiquette

In addition to the anti-harassment policy, ACM@UC has an etiquette consisting of four key values.

#### No feigning surprise
You shouldn’t act surprised when people say they don't know something. This applies to both technical things ("What?! I can't believe you don't know what the stack is!") and non-technical things ("You don't know who RMS is?!").

Feigning surprise has absolutely no social or educational benefit: When people feign surprise, it's usually to make them feel better about themselves and others feel worse. And even when that's not the intention, it's almost always the effect.

#### No ‘well-actually’s’
A well-actually happens when someone says something that's almost - but not entirely - correct, and you say, "well, actually…" and then give a minor correction.

This is especially annoying when the correction has no bearing on the actual conversation.

#### No backseat driving
If you overhear people working through a problem, you shouldn't intermittently lob advice across the room.

This can lead to the "too many cooks" problem, but more important, it can be rude and disruptive to half-participate in a conversation.

This isn't to say you shouldn't help, offer advice, or join conversations. On the contrary, we encourage all those things. Rather, it just means that when you want to help out or work with others, you should fully engage and not just butt in sporadically.

#### Let the learner drive
At times it may be faster when you're helping someone to jump on their keyboard and just get the task done, but that's no way to learn.

Although at times this takes a great deal of patience for both parties, in the end, one of the best ways to learn is by doing. So, unless someone offers their keys up, let them do the driving.

## Moderation
Participants asked to stop any harassing behavior or asked to respect the etiquette are expected to comply immediately.

Faculty, sponsors, ACM@UC executives, and all people interacting with ACM@UC are also subject to this Code of Conduct.

ACM@UC executives may take action to redress anything designed to, or with the clear impact of, disrupting the community or making the environment hostile for any community members.

## Where does the Code of Conduct apply?
We expect community members to follow the Code of Conduct at all meetings, events, and community-related social activities.

In addition, the Code of Conduct applies to the following online media:
* The [Slack](http://acmcincy.slack.com/)
* The [Facebook group](http://facebook.com/groups/acmatuc)
* The [Twitter](http://twitter.com/ACMatUCorg)
* The [GitHub](http://github.com/ACMatUC)

## Reporting an issue
If someone makes you or anyone else feel unsafe or unwelcome, please report it as soon as possible. Harassment and other code of conduct violations make our community less pleasant for everyone.

You can make a report either personally or anonymously.

#### Anonymous report
You can make an anonymous report [here](https://goo.gl/forms/r3yF2xE0gU0yKaCb2).

We can't follow up an anonymous report with you directly, but we will fully investigate it and take whatever action is necessary to prevent a recurrence.

#### Personal report
You can make a personal report by contacting the ACM@UC President or Vice President:

* Brandon Starcheus (President), [starchbt@mail.uc.edu](mailto:starchbt@mail.uc.edu), @BStar on Slack
* Lina Kaval (Vice President), [kavalla@mail.uc.edu](mailto:kavalla@mail.uc.edu), @Lina Kaval on Slack

When taking a personal report in-person, an ACM@UC executive will ensure you are safe and cannot be overheard. They may involve other ACM@UC executives to ensure your report is managed properly. Once safe, we'll ask you to tell us about what happened. You won't be asked to confront anyone and we won't tell anyone who you are. We'll handle it as respectfully as possible.

## Questions and feedback
Please direct any questions and feedback to an ACM@UC executive in-person, by email, or on Slack or by sending an email to [acmatcinci@gmail.com](acmatcinci@gmail.com).

## License and attribution
We used the [Geek Feminism Conference anti-harassment policy](http://geekfeminism.wikia.com/wiki/Conference_anti-harassment/Policy) and the [NodeSchool Cincinnati Code of Conduct](https://github.com/nodeschool/cincinnati/blob/master/resources/slides/index.html) as a starting point. This Code of Conduct is licensed Creative Commons Zero.

---

Version 1.0.1. Published September 10, 2018.  
Version 1.0.2. Published May 22, 2020.  

[View History on GitHub](https://github.com/ACMatUC/acmatuc.github.io/commits/master/conduct.md)
