using System;
using System.Collections.Generic;
using System.Web;
using System.IO;
using System.Collections;


/// <summary>
/// UEditor༭ͨϴ
/// </summary>
public  class Uploader
{
     string state = "SUCCESS";

     string URL = null;
     string currentType = null;
     string uploadpath = null;
     string filename = null;
     string originalName = null;
     HttpPostedFile uploadFile = null;

    /**
  * ϴļ
  * @param HttpContext
  * @param string
  * @param  string[]
  *@param int
  * @return Hashtable
  */
    public  Hashtable upFile(HttpContext cxt, string pathbase, string[] filetype, int size)
    {
        pathbase = pathbase + DateTime.Now.ToString("yyyy-MM-dd") + "/";
        uploadpath = cxt.Server.MapPath(pathbase);//ȡļϴ·

        try
        {
            uploadFile = cxt.Request.Files[0];
            originalName = uploadFile.FileName;

            //Ŀ¼
            createFolder();

            //ʽ֤
            if (checkType(filetype))
            {
                state = "ļ";
            }
            //С֤
            if (checkSize(size))
            {
                state = "ļСվ";
            }
            //ͼƬ
            if (state == "SUCCESS")
            {
                filename = reName();
                uploadFile.SaveAs(uploadpath + filename);
                URL = pathbase + filename;
            }
        }
        catch (Exception e)
        {
            state = "δ֪";
            URL = "";
        }
        return getUploadInfo();
    }

    /**
 * ϴͿѻ
  * @param HttpContext
  * @param string
  * @param  string[]
  *@param string
  * @return Hashtable
 */
    public  Hashtable upScrawl(HttpContext cxt, string pathbase, string tmppath, string base64Data)
    {
        pathbase = pathbase + DateTime.Now.ToString("yyyy-MM-dd") + "/";
        uploadpath = cxt.Server.MapPath(pathbase);//ȡļϴ·
        FileStream fs = null;
        try
        {
            //Ŀ¼
            createFolder();
            //ͼƬ
            filename = System.Guid.NewGuid() + ".png";
            fs = File.Create(uploadpath + filename);
            byte[] bytes = Convert.FromBase64String(base64Data);
            fs.Write(bytes, 0, bytes.Length);

            URL = pathbase + filename;
        }
        catch (Exception e)
        {
            state = "δ֪";
            URL = "";
        }
        finally
        {
            fs.Close();
            deleteFolder(cxt.Server.MapPath(tmppath));
        }
        return getUploadInfo();
    }

    /**
* ȡļϢ
* @param context
* @param string
* @return string
*/
    public  string getOtherInfo(HttpContext cxt, string field)
    {
        string info = null;
        if (cxt.Request.Form[field] != null && !String.IsNullOrEmpty(cxt.Request.Form[field]))
        {
            info = field == "fileName" ? cxt.Request.Form[field].Split(',')[1] : cxt.Request.Form[field];
        }
        return info;
    }

    /**
     * ȡϴϢ
     * @return Hashtable
     */
    private  Hashtable getUploadInfo()
    {
        Hashtable infoList = new Hashtable();

        infoList.Add("state", state);
        infoList.Add("url", URL);

        if (currentType != null)
            infoList.Add("currentType", currentType);
        if (originalName != null)
            infoList.Add("originalName", originalName);
        return infoList;
    }

    /**
     * ļ
     * @return string
     */
    private  string reName()
    {
        return System.Guid.NewGuid() + getFileExt();
    }

    /**
     * ļͼ
     * @return bool
     */
    private  bool checkType(string[] filetype)
    {
        currentType = getFileExt();
        return Array.IndexOf(filetype, currentType) == -1;
    }

    /**
     * ļС
     * @param int
     * @return bool
     */
    private  bool checkSize(int size)
    {
        return uploadFile.ContentLength >= (size * 1024*1024);
    }

    /**
     * ȡļչ
     * @return string
     */
    private  string getFileExt()
    {
        string[] temp = uploadFile.FileName.Split('.');
        return "." + temp[temp.Length - 1].ToLower();
    }

    /**
     * Զ洢ļ
     */
    private  void createFolder()
    {
        if (!Directory.Exists(uploadpath))
        {
            Directory.CreateDirectory(uploadpath);
        }
    }

    /**
     * ɾ洢ļ
     * @param string
     */
    public  void deleteFolder(string path)
    {
        //if (Directory.Exists(path))
        //{
        //    Directory.Delete(path, true);
        //}
    }
}