# `13` Relative Length em, rem

By now, we are used to working with pixels as a measurement unit, for example, saying that a box has `100px` of width.

There are other types of units that are not fixed, but relative. We use them when we want the element size to be related to another element or measurement unit.

## Example using `em`:

In this exercise we have two `<h2>` headings. They are both `<h2>`, but one is bigger than the other because headings have relative font-sizes by default. 

Since the second `div` has a bigger based `font-size`, then the heading resizes accordingly.

## In short:

+ `em`: Relative to the current `font-size` of the parent.

+ `rem`: Relative to the original `font-size` of the page.


## 📝 Instructions:

1. Give a `font-size` of `0.8em` to both `h2`'s.

2. Now give a `font-size` of `0.8rem` to both `h3`'s.

## 💻 Expected result:

![Expected result](../../.learn/assets/12-1.png?raw=true)


