---
tutorial: "https://www.youtube.com/watch?v=h9WPp8gPMS8"
---
# `01` Inline styles

CSS is about adding styles to our HTML elements. 

The most **basic** way to apply a style to an HTML element is to use the html `style` attribute within the tag. This is called "inline styles" and works like this:

```HTML
<a href="google.com" style="color: red; font-size: 14px;">Go to Google</a>
```

This will set the text color of the link above to red, and the font size to 14 pixels.

In contemporary web design this way of applying styles is **discouraged**, because it is not efficient - you have to apply styles tag by tag. But you will run into examples of it and need to be familiar with it.   

To apply styles you always have to follow thеse steps:

1. Read the HTML and pick what element you want to decorate to apply CSS to it.
2. Apply the style with the `style` attribute as above. 

That is it! The rest is just semantics! 😁

## 📝 Instructions:

1. Set an inline style to change the `background-color` of the table to green.

## 💡 Hint:

- How to use `background-color`: https://www.w3schools.com/cssref/pr_background-color.php
