---
tutorial: "https://www.youtube.com/watch?v=c5JeXOnI-Sg"
---

# `01` Inline styles

El CSS se trata de agregar estilos a nuestros elementos HTML.

La forma más **básica** de aplicar un estilo a un elemento HTML es usar el atributo `style` dentro de la etiqueta HTML. Esto se llama "estilos en línea" (*inline style*) y funciona así:

```html
<a href="google.com" style="color: red; font-size: 14px;">Ir a Google</a>
```

Esto establecerá el `color` del texto del enlace anterior a rojo y el tamaño de fuente (`font-size`) en 14 píxeles.

En el diseño web contemporáneo, esta forma de aplicar estilos se desaconseja porque no es eficiente: tienes que aplicar estilos etiqueta por etiqueta. Pero te encontrarás con ejemplos de esto y necesitarás estar familiarizado con ello.

Para aplicar estilos, siempre tienes que seguir estos pasos:

1. Leer el HTML y seleccionar qué elemento deseas decorar para aplicarle CSS.
2. Aplicar el estilo con el atributo `style` como se muestra arriba.

## 📝 Instrucciones:

1. Establece un estilo en línea para cambiar el color de fondo (`background-color`) de la tabla a verde.

## 💡 Pista:

- Cómo usar `background-color`: https://www.w3schools.com/cssref/pr_background-color.php
