# CSS Exercises Tutorial at 4Geeks Academy
<!-- hide -->
<table>
  <tr>
    <td><img src="https://github.com/4GeeksAcademy/css-tutorial-exercises-course/blob/master/.learn/assets/4geeks-icon-blue.png?raw=true"></td>
    <td>
      <img src="https://img.shields.io/github/last-commit/4geeksacademy/css-tutorial-exercises-course" />
      <a href="https://breatheco.de"><img src="https://img.shields.io/badge/certified-BreatheCode-blue" /></a>
      <a href="https://twitter.com/alesanchezr"><img src="https://img.shields.io/twitter/follow/alesanchezr?style=social&logo=twitter" alt="follow on Twitter"></a>
      <a href="https://gitpod.io#https://github.com/4GeeksAcademy/css-tutorial-exercises-course.git"><img src="https://img.shields.io/badge/Gitpod-ready--to--code-blue?logo=gitpod" /></a>
    </td>
  </tr>
</table>

Hi! I'm [Alejandro Sanchez @alesanchezr](https://github.com/alesanchezr), really excited to have you here! 🎉 😂 Learning to code is hard; you need coaching! [DM me on twitter](https://twitter.com/alesanchezr) if you have any questions. 

*Estas instrucciones [están disponibles en 🇪🇸 español](https://github.com/4GeeksAcademy/css-tutorial-exercises-course/blob/master/README.es.md) :es:*
<!-- endhide -->

## You'll be learning the following concepts:

1. How to apply CSS to your website in 3 different ways: inline, by grouping them together inside a `<style>` tag, or by using an external stylesheet `<link>`.

2. Selecting HTML Elements from your website to apply the styles to.

3. Apply CSS Rules (styles) to those elements.

4. Use the most popular CSS Rules.

5. Learn the most popular CSS Tricks.

<!-- hide -->
#### Before we start... other related tutorials

<ol>
  <li><a href="https://github.com/4GeeksAcademy/html-tutorial-exercises-course">Learn HTML</a></li>
    <li><a href="https://github.com/4GeeksAcademy/html-forms-tutorial-exercises">Learn HTML5 Forms</a></li>
  <li><a href="https://github.com/4GeeksAcademy/css-tutorial-exercises-course">Learn CSS</a>← 🔥 You are here now!</li>
  <li><a href="https://github.com/4GeeksAcademy/css-layouts-tutorial-exercises">Learn CSS Layouts</a></li>
  <li><a href="https://github.com/4GeeksAcademy/bootstrap-exercises-tutorial">Learn Bootstrap</a></li>
</ol>

Complete selection of autograded CSS exercises, for anyone interested in learning CSS!

## One click installation (recommended):

You can open these exercises in just a few seconds by clicking: [Open in Codespaces](https://codespaces.new/?repo=4GeeksAcademy/css-tutorial-exercises-course) (recommended) or [Open in Gitpod](https://gitpod.io#https://github.com/4GeeksAcademy/css-tutorial-exercises-course.git).

> Once you have VSCode open the LearnPack exercises should start automatically. If exercises don't run automatically you can try typing on your terminal: `$ learnpack start`

## Manual installation

[Clone the repository](https://4geeks.com/how-to/github-clone-repository) in your local environment and follow the steps below:

1) Install LearnPack, the package manager for learning tutorials and the HTML compiler plugin for LearnPack; make sure you also have node.js 14+:

```bash
$ npm i learnpack -g
$ learnpack plugins:install learnpack-html
```

2) Download the exercises 

```bash
$ learnpack install css-tutorial-exercises-course
```

> Note: Once you finish downloading, you will need to `cd` into the exercises folder which contains all the exercises.

3) Start the tutorial/exercises by running the following command at the same level where your learn.json file is:

```bash
$ npm i jest@24.8.0 -g
$ learnpack start
```
<!-- endhide -->

## How are the exercises organized?

Each exercise is a small React application containing the following files:

1. **index.html:** all websites and exercises start from the index.html.
2. **styles.css:** your CSS code goes here, some exercises will make you update this file.
3. **README.md:** contains exercise instructions.
4. **test.js:** you don't have to open this file, it contains the testing script for the exercise.

> Note: The exercises have automatic grading but it's very rigid and strict, my recommendation is to not take the tests too serious and use them only as a suggestion or you may get frustrated.

## Contributors

Thanks goes to these wonderful people ([emoji key](https://github.com/kentcdodds/all-contributors#emoji-key)):

1. [Alejandro Sanchez (alesanchezr)](https://github.com/alesanchezr), contribution: (coder) 💻  (idea) 🤔, (run-tests) ⚠️ , (pull-request-review) 👀 (run-tutorial) ✅ (documentation) 📖

2. [Paolo (plucodev)](https://github.com/plucodev), contribution: (bug reports) 🐛, contribution: (coder), (translation) 🌎

3. [Daniel Machota (@d4rkm0nst3r)](https://github.com/d4rkm0nst3r), contribution: (run-tutorial) ✅, Translation 🌍

<!-- hide -->
This and many other exercises are built by students as part of the 4Geeks Academy [Coding Bootcamp](https://4geeksacademy.com/us/coding-bootcamp) by [Alejandro Sánchez](https://twitter.com/alesanchezr) and many other contributors. Find out more about our [Full Stack Developer Course](https://4geeksacademy.com/us/coding-bootcamps/part-time-full-stack-developer), and  [Data Science Bootcamp](https://4geeksacademy.com/us/coding-bootcamps/datascience-machine-learning).
<!-- endhide -->
