# Tutorial de Ejercicios de CSS de 4Geeks Academy
<!-- hide -->
<table>
  <tr>
    <td><img src="https://github.com/4GeeksAcademy/css-tutorial-exercises-course/blob/master/.learn/assets/4geeks-icon-blue.png?raw=true"></td>
    <td>
      <img src="https://img.shields.io/github/last-commit/4geeksacademy/css-tutorial-exercises-course" />
      <a href="https://breatheco.de"><img src="https://img.shields.io/badge/certified-BreatheCode-blue" /></a>
      <a href="https://twitter.com/alesanchezr"><img src="https://img.shields.io/twitter/follow/alesanchezr?style=social&logo=twitter" alt="follow on Twitter"></a>
      <a href="https://gitpod.io#https://github.com/4GeeksAcademy/css-tutorial-exercises-course.git"><img src="https://img.shields.io/badge/Gitpod-ready--to--code-blue?logo=gitpod" /></a>
    </td>
  </tr>
</table>

¡Hola! Soy [Alejandro Sanchez @alesanchezr](https://github.com/alesanchezr), ¡muy emocionado de tenerte aquí! 🎉 😂 Aprender a programar es difícil, ¡necesitas entrenamiento! [Envíame un DM en Twitter](https://twitter.com/alesanchezr) si tienes alguna pregunta. 
<!-- endhide -->

## En este tutorial aprenderás los siguientes conceptos:

1. Cómo aplicar CSS a su sitio web de 3 maneras diferentes: en línea, agrupándolos dentro de una etiqueta `<style>` o usando una hoja de estilos externa `<link>`.

2. Seleccionar elementos HTML de su sitio web para aplicar los estilos.

3. Aplicar Reglas CSS (estilos) a esos elementos.

4. Utilizar las reglas CSS más populares.

5. Aprender los trucos CSS más populares.

<!-- hide -->
#### Antes de empezar... hay otros tutoriales 

<ol>
  <li><a href="https://github.com/4GeeksAcademy/html-tutorial-exercises-course">Aprende HTML</a></li>
  <li><a href="https://github.com/4GeeksAcademy/html-forms-tutorial-exercises">Aprende Formularios HTML5 </a></li>
  <li><a href="https://github.com/4GeeksAcademy/css-tutorial-exercises-course">Aprende CSS</a>← 🔥 Estás aquí</li>
    <li><a href="https://github.com/4GeeksAcademy/css-layouts-tutorial-exercises">Aprende CSS Layouts</a></li>
  <li><a href="https://github.com/4GeeksAcademy/bootstrap-exercises-tutorial">Aprende Bootstrap</a></li>
</ol>

Una completa selección de Ejercicios autograduados sobre CSS ¡para cualquier interesado en aprender CSS!

## Instalación en un clic (recomendado)

Puedes empezar estos ejercicios en pocos segundos haciendo clic en: [Abrir en Codespaces](https://codespaces.new/?repo=4GeeksAcademy/css-tutorial-exercises-course) (recomendado) o [Abrir en Gitpod](https://gitpod.io#https://github.com/4GeeksAcademy/css-tutorial-exercises-course.git).

> Una vez ya tengas abierto VSCode los ejercicios de LearnPack deberían empezar automáticamente, si esto no sucede puedes intentar empezar los ejercicios escribiendo este comando en tu terminal: `$ learnpack start`

## Instalación manual 

Clona el repositorio en tu ambiente local y sigue los siguientes pasos:

1. Instala LearnPack, el package manager para tutoriales de aprendizaje y el HTML compiler plugin para LearnPack, asegúrate también de tener node.js 14+:

```bash
$ npm i learnpack -g
$ learnpack plugins:install learnpack-html
```

2. Descarga estos ejercicios en particular usando LearnPack y luego `cd` para entrar en la carpeta: 

```bash
$ learnpack install css-tutorial-exercises-course
```

> Nota: Una vez que termines de descargar, encontrarás una carpeta "exercises" que contiene todos los ejercicios.

3. Inicializa el tutorial/ejercicios ejecutando el siguiente comando en el mismo nivel donde se encuentra tu archivo learn.json:

```bash
$ npm i jest@24.8.0 -g
$ learnpack start
```

<!-- endhide -->
## ¿Cómo están organizados los ejercicios?

Cada ejercicio es una pequeña aplicación de React que contiene los siguientes archivos:

1. **index.html:** representa el archivo de entrada para el ejercicio.
2. **styles.css:** contiene los estilos y reglas de CSS
3. **README.md:** contiene las instrucciones de los ejercicios.
4. **test.js:** no tienes que abrir este archivo, contiene el script del test para el ejercicio.

> Nota: Los ejercicios son autograduados, pero los tests son muy rígidos y estrictos, mi recomendación es que no prestes demasiada atención a los tests y los uses solo como una sugerencia o podrías frustrarte.

## Colaboradores
 
Gracias a estas personas maravillosas ([emoji key](https://github.com/kentcdodds/all-contributors#emoji-key)):

1. [Alejandro Sanchez (alesanchezr)](https://github.com/alesanchezr), contribución: (codificador) 💻 (idea) 🤔, (run-tests) ⚠️ , (pull-request-review) 🤓 (tutorial de compilación) ✅ (documentación) 📖

2. [David Hay (haydavid23)](https://github.com/haydavid23), contribución: (tests) ⚠️

3. [Daniel Machota (@d4rkm0nst3r)](https://github.com/d4rkm0nst3r), contribución: (run-tutorial) ✅, Traducción 🌍

Este proyecto sigue la especificación [all-contributors](https://github.com/kentcdodds/all-contributors). ¡Todas las contribuciones son bienvenidas!

Este y otros ejercicios son usados para [aprender a programar](https://4geeksacademy.com/es/aprender-a-programar/aprender-a-programar-desde-cero) por parte de los alumnos de 4Geeks Academy [Coding Bootcamp](https://4geeksacademy.com/us/coding-bootcamp) realizado por [Alejandro Sánchez](https://twitter.com/alesanchezr) y muchos otros contribuyentes. Conoce más sobre nuestros [Cursos de Programación](https://4geeksacademy.com/es/curso-de-programacion-desde-cero?lang=es) para convertirte en [Full Stack Developer](https://4geeksacademy.com/es/coding-bootcamps/desarrollador-full-stack/?lang=es), o nuestro [Data Science Bootcamp](https://4geeksacademy.com/es/coding-bootcamps/curso-datascience-machine-learning).

