# 操作系统课程设计 仿真Linux系统

### 项目简介
1. 本工程根据南京农业大学人工智能学院 JHY教授 操作系统课程设计中相关选题设计（难度系数5）
2. 本工程全部采用Java语言设计，仿真实现了Linux系统的进程管理、作业管理、调度管理、设备管理、文件管理等内容
3. 本工程所有源代码在30天内完成，时间较为仓促，设计不当之处还请不吝赐教

### 运行与安装
1. clone 或 pull 所有文件
2. 使用IDEA（推荐） 或 Eclipse 新建Java工程（JDK 版本 >= 1.8）
3. 删除工程下默认生成的src目录
4. 将文件解压后的/src，/static/，xxxxx-jobs-input.txt文件全部复制到工程根目录下
5. 使用IDEA 或 Eclipse 内的运行功能开始运行，或自行生成.jar可执行文件等

### 使用与说明
1. 首次使用，需删除xxxxx-jobs-input.txt文件下除首行外所有内容，切记第一行末尾没有换行符！
2. 本工程提供的可视化操作界面、文件系统命令行、文件系统视窗，用户基本能够自行探索功能
3. 文件系统命令行提供如下命令（只能英文输入法下使用）
    + ls [-l]			显示当前目录下的文件信息
      					-l          显示详细信息
    + cd dir          切换当前工作目录
                      dir         指定目录绝对或相对路径
    + mkdir dir [-p]  当前目录下创建目录
                      dir         指定目录绝对或相对路径
                      -p          递归创建
    + touch file/dir  当前目录下创建一个新的文件；文件已存在，则更新文件的修改时间
                      file/dir    文件或目录路径
    + rmdir dir -p    当前目录下删除目录
                      dir         目录路径
                      -p          当子目录被删除后使其也成为空目录，则一并删除
    + rm file/dir [-r] 当前目录下删除文件或目录
                      file/dir    文件或目录路径
                      -r          递归删除，参数必须是目录 
    + close file/dir  关闭文件或目录
                      file/dir    文件或目录路径
    + cat file        显示文件内容
                      file        文件路径
    + vim file        修改文件内容        
      					file        文件路径
    + link old new    链接到一个已存在文件
                      old         已存在文件的目录
                      new         新文件目录
    + chmod mode path [-r] 改变某个文件或目录的权限
                      mode        权限模式 000-777
                      path        文件或目录路径
                      -r          递归修改，一并修改目录及其以下所有子文件的权限
    + explorer       打开资源管理器
4. 命令行输入explorer命令，进入更加友好的视窗风格界面，提供以下功能（鼠标点击操作时请尽量减少鼠标移动）
    + 鼠标左键单击目录，进入相关目录。
    + 鼠标左键单击文件，查看文件信息。
    + 鼠标左键双击文件，打开文件或目录。
    + 鼠标右键单机文件，进行打开、重命名、删除操作
    + 鼠标右键单机文件列表空白处，新建文件或目录。
    + 鼠标单机左上方前进后退按钮，切换历史访问路径。
5. /src/gui目录下的.jfd文件为IDEA插件JFormDesign绘制swing时的配置文件，不影响程序运行；如需使用，请自行下载

### 友情提示
1. 请不要直接复制源代码提交课设作业！
2. 本工程代码结构较为庞大，不建议二次开发，鼓励借鉴思路
3. 源代码含有详细注释，可以满足基本的阅读需求
4. 如依然存在问题，请联系qq：404874351
