# replace-method [![Flattr this!](https://api.flattr.com/button/flattr-badge-large.png)](https://flattr.com/submit/auto?user_id=hughskennedy&url=http://github.com/hughsk/replace-method&title=replace-method&description=hughsk/replace-method%20on%20GitHub&language=en_GB&tags=flattr,github,javascript&category=software)[![experimental](http://hughsk.github.io/stability-badges/dist/experimental.svg)](http://github.com/hughsk/stability-badges) #

JavaScript post-processing step to replace specific function/method calls with
other bits of JavaScript. It doesn't take scope into account, but is otherwise
a good starting point for writing your own inlinifying transform modules like
[`brfs`](http://github.com/substack/brfs).

## Usage ##

[![replace-method](https://nodei.co/npm/replace-method.png?mini=true)](https://nodei.co/npm/replace-method)

### `replace = require('replace-method')(ast)` ###

Returns a function you can use to replace methods with other things.

Where `ast` is either a string of source code, or an AST object such as one
generated by [esprima](http://github.com/ariya/esprima/).

### `replace(method, found)` ###

Where `method` is an array of variable names, such that:

* `['__filename']` will match `__filename`.
* `['fs', 'readFileSync']` will match `fs.readFileSync`.
* `['a', 'nested', 'property']` will match `a.nested.property`.

`found` is then called once per every node in the AST found – if you return
nothing or `undefined`, nothing will change. However, if you return an AST
object that content will be replaced, e.g.:

``` javascript
return {
  type: 'Literal',
  value: 'hello world'
}
```

Will replace the matched variable with the string `"hello world"`.

### `replace.code()` ###

Returns the updated version of your code after having made the transformations
you needed. Note that the supplied `ast` object you provided will be modified
directly so you can convert it to JavaScript yourself or hand it off to other
processing steps if need be.

## Example ##

``` javascript
var replaceMethod  = require('replace-method')
var evaluate       = require('static-eval')
var escodegen      = require('escodegen')
var esprima        = require('esprima')
var fs             = require('fs')

var src = replaceMethod(
  fs.readFileSync(__filename, 'utf8')
)

src.replace(['fs', 'readFileSync'], function(node) {
  if (!node.arguments.length) return

  var filename = evaluate(node.arguments[0], {
      __filename: __filename
    , __dirname:  __dirname
  })

  if (filename) return {
      type: 'Literal'
    , value: fs.readFileSync(filename, 'utf8')
  }
})

console.log(src.code())
```

## License ##

MIT. See [LICENSE.md](http://github.com/hughsk/replace-method/blob/master/LICENSE.md) for details.
