1. 什么是随机森林

   - **自助法**（Bootstrap Method，Bootstrapping，或**自助抽样法**、**拔靴法**）是一种从给定训练集中有放回的均匀抽样，也就是说，每当选中一个样本，它等可能地被再次选中并被再次添加到训练集中。

   - Bagging思想

     Bagging(bootstrap aggregating)，就是从总体样本当中随机取一部分样本、随机取一部分属性进行训练，通过多次这样的操作获得多个模型。通常对分类任务使用简单投票法，对回归任务使用简单平均法。这样极大可能的避免了不好的样本数据、不好的属性，从而提高准确度。因为不好的样本、不好的属性相当于噪声，模型学入噪声后会使准确度不高。

   - 随机森林

     随机森林(Random  Forest)是一种以决策树为基础模型的Bagging模型。

     **每棵树的按照如下规则生成：**

     1. 如果训练集大小为N，对于每棵树而言，**随机**且有放回地从训练集中的抽取N个训练样本，作为该树的训练集；
     2. 如果每个样本的特征维度为M，指定一个常数m<<M，**随机**地从M个特征中选取m个特征子集，每次树进行分裂时，从这m个特征中选择最优的；
     3. 每棵树都尽最大程度的生长，并且没有剪枝过程。（因为随机森林中的每一棵树都只是对原数据集的一个子集进行学习，我们需要它在某一片的数据中有非常好的拟合性而不需要担心在全数据集上的过拟合。）

2. 随机森林分类效果的影响因素

   - 森林中任意两棵树的相关性：相关性越大，错误率越大；
   - 森林中每棵树的分类能力：每棵树的分类能力越强，整个森林的错误率越低。

   减小特征选择个数m，树的相关性和分类能力也会相应的降低；增大m，两者也会随之增大。所以关键问题是如何选择最优的m（或者是范围），使得相关性与单棵树的分类能力间能有一个很好的平衡从而得到最优的分类效果。

3. OOB(Out of Bag)袋外数据

   bagging方法中Bootstrap每次约有1/3的样本不会出现在Bootstrap所采集的样本集合中，当然也就没有参加决策树的建立，把这1/3的数据称为**袋外数据oob（out of bag）**,它可以用于取代测试集误差估计方法。

4. 随机森林优点

   - 两个随机的引入（样本与属性选择的随机），使得模型不容易过拟合，并且模型抗噪声能力很强。

   - 能够处理很高维度的数据并且不需要做特征选择。
   - 由于基础模型间互不影响，因此可以并行训练，训练速度很快。
   - 由于有OOB数据的存在，因此能在不损失训练数据的情况下得到误差的无偏估计。

5. 随机森林如何得到特征的重要性

   - 训练时基于决策树分裂时每个特征总的/平均的分裂次数、信息增益、Gini不纯度下降量。

   - 训练后基于OOB错误率进行量化打分

     具体来说，先用训练好的模型对OOB数据进行打分，计算出AUC或其他业务定义的评估指标；接着对OOB数据中的每个特征：

     1. 随机打乱当前特征的取值；

     2. 重新对当前数据进行打分，计算评估指标；

     3. 计算指标变化率

     按照上面方式，对每个特征都会得到一个变化率，最后按照变化率排序来量化特征重要性。

6. Bagging降低方差

   Bagging对样本重采样，对每一重采样得到的子样本集训练一个模型，最后取平均。由于子样本集的相似性以及使用的是同种模型，因此各模型有近似相等的bias和variance（事实上，各模型的分布也近似相同，但不独立）。

   另一方面，若各子模型独立，则有![[公式]](https://www.zhihu.com/equation?tex=Var%28%5Cfrac%7B%5Csum+X_i%7D%7Bn%7D%29%3D%5Cfrac%7BVar%28X_i%29%7D%7Bn%7D)，此时可以显著降低variance。若各子模型完全相同，则![[公式]](https://www.zhihu.com/equation?tex=Var%28%5Cfrac%7B%5Csum+X_i%7D%7Bn%7D%29%3DVar%28X_i%29)

   ，此时不会降低variance。bagging方法得到的各子模型是有一定相关性的，属于上面两个极端状况的中间态，因此可以一定程度降低variance。

7. 随机森林为什么使用自助法对样本进行随机抽样
   -  如果不放回抽样，那么每棵树用的样本差异性太大，基学习器之间的相似性小，投票结果差，模型偏差大；
   - 自助采样一定程度上改变了每个基学习器所用数据的样本分布，一定程度上引入了噪音，增加了模型的泛化能力。

