1. 什么是聚类算法

   聚类是一种机器学习技术，它涉及到数据点的分组。给定一组数据点，我们可以使用聚类算法将每个数据点划分为一个特定的组。理论上，同一组中的数据点应该具有相似的属性和/或特征，而不同组中的数据点应该具有高度不同的属性和/或特征。**聚类是一种无监督学习的方法**，是许多领域中常用的统计数据分析技术。

2. 高斯混合聚类（GMM）

   GMM在EM算法一节介绍。下面K-Means的推导也会用到GMM。

3. K均值聚类（K-Means）

   K-Means是最基础和普及的聚类算法，需要事先指定聚类数K，算法流程为：

   - 随机选择K个点$\mu_1,\mu_2,...,\mu_K$作为聚类中心；
   - 对于数据集中的N个点$x_1,x_2,...,x_N$，分别计算每个点与所有聚类中心的距离并将其归入距离最近的一个类簇；
   - 计算每个类簇内所有点的均值作为该类簇新的聚类中心；
   - 重复上述步骤直到聚类中心不再变化或者变化不大。

   下图展现了K-Means的动态过程：

   [![ySXoDO.gif](https://s3.ax1x.com/2021/01/28/ySXoDO.gif)](https://imgchr.com/i/ySXoDO)

   K-Means可以使用EM算法来解释：

   将$\mu=(\mu_1,\mu_2,...,\mu_K)$作为模型参数，将$\gamma=((\gamma_{11},\gamma_{12},...,\gamma_{1K}),(\gamma_{21},\gamma_{22},...,\gamma_{2K}),...,(\gamma_{N1},\gamma_{N2},...,\gamma_{NK}))$作为隐藏序列，$X=(x_1,x_2,...,x_N)$为观测序列，设所有类簇都符合方差相同的高斯分布，即：
   $$
   P(x|\mu_k)=\frac{1}{\sqrt {2\pi}\sigma}e^{-\frac{(x-\mu_k)^2}{2\sigma^2}},k=1,2,...,K
   $$
   则完全数据的似然函数为：
   $$
   P(X,\gamma|\mu)=\prod_{j=1}^N\prod_{k=1}^K(\frac{1}{\sqrt {2\pi}\sigma}e^{-\frac{(x_j-\mu_k)^2}{2\sigma^2}})^{\gamma_{jk}}
   $$
   完全数据的对数似然函数为：
   $$
   \log P(X,\gamma|\mu)=\sum_{j=1}^N\sum_{k=1}^K\gamma_{jk}\log(\frac{1}{\sqrt {2\pi}\sigma}e^{-\frac{(x_j-\mu_k)^2}{2\sigma^2}})
   \\=\sum_{j=1}^N\sum_{k=1}^K\gamma_{jk}(-\log \sqrt {2\pi}\sigma-\frac{(x_j-\mu_k)^2}{2\sigma^2})
   $$
   则Q函数为：
   $$
   Q(\mu,\mu^{(i)})=E(\log P(X,\gamma|\mu)|X,\mu^{(i)})
   \\=E(\sum_{j=1}^N\sum_{k=1}^K\gamma_{jk}(-\log \sqrt {2\pi}\sigma-\frac{(x_j-\mu_k)^2}{2\sigma^2}))
   \\=\sum_{j=1}^N\sum_{k=1}^KE(\gamma_{jk})(-\log \sqrt {2\pi}\sigma-\frac{(x_j-\mu_k)^2}{2\sigma^2})
   $$
   由于：
   $$
   E(\gamma_{jk})=\left\{\begin{aligned}
   1 \qquad  k=\arg\min_k(x_j-\mu_k^{(i)})^2
   \\
   0 \qquad\qquad\qquad\qquad otherwise
   \end{aligned}\right.
   $$
   设$\arg\min_k(x_j-\mu_k^{(i)})^2=y_j$，则：
   $$
   Q(\mu,\mu^{(i)})=\sum_{j=1}^N(-\log \sqrt {2\pi}\sigma-\frac{(x_j-\mu_{y_j})^2}{2\sigma^2})
   $$
   最大化Q函数：
   $$
   \arg\max_{\mu}  Q(\mu,\mu^{(i)})=\arg\max_{\mu}\sum_{j=1}^N(-\log \sqrt {2\pi}\sigma-\frac{(x_j-\mu_{y_j})^2}{2\sigma^2})
   \\
   =\arg\max_{\mu}\sum_{j=1}^N-(x_j-\mu_{y_j})^2
   \\
   =\arg\min_{\mu}\sum_{j=1}^N(x_j-\mu_{y_j})^2
   $$
   令$J=\sum_{j=1}^N(x_j-\mu_{y_j})^2$为K-Means的损失函数，则最大化Q函数等价于最小化损失函数。对各个聚类中心求导并令其等于0得：
   $$
   \mu_k^{(i+1)}=\frac{1}{M}\sum_{j=1}^Mx_j\qquad k=1,2,...,K
   $$
   其中$x_j$满足$\arg\min_k(x_j-\mu_k^{(i)})^2=k$，M为满足条件的$x_j$的个数。

   K-Means的优点：

   - 计算简单，速度快；

   K-Means的缺点：

   - 必须指定聚类数目K；
   - 可能找到的是局部最优而非全局最优；
   - 计算复杂度高；
   - 容易受噪音点影响；

   K-Means存在很多种改进方案，如：

   - K-Means++改进了K-Means初始聚类中心的选择方法，首先从数据集中随机选取一个样本点作为初始聚类中心；接着计算每个样本与当前已有聚类中心之间的最短距离（即最近的聚类中心的距离），值越大被选择作为下一个聚类中心的概率越大；重复选取K个聚类中心。

     这样做能够让初始的聚类中心分布更加均匀。

   - K-Medians用数据集的中位数而不是均值来计算数据的中心点。
     K-Medians的优势是使用中位数来计算中心点不受异常值的影响；缺点是计算中位数时需要对数据集中的数据进行排序，速度相对于K-Means较慢。
   - Mini Batch K-Means适合在数据规模很大的时候使用，每次使用小批次数据进行K-Means更新聚类中心直到算法稳定。

4. 均值漂移聚类（Mean shift）

   均值漂移聚类是一种基于密度的聚类方法，无需指定聚类数，其流程为：

   - 首先找到一个中心点center（随机选择），然后根据半径划分一个范围；

   - 把这个范围内的点输入簇c的标记个数加1；

   - 在这个范围内，计算其它点到这个点的平均距离，并把这个平均距离当成偏移量 shift；

   - 把中心点center移动偏移量 shift 个单位，当成新的中心点；

   - 重复上述步骤直到 shift小于一定阈值，即收敛；

   - 如果当前簇c的center和另一个簇c2的center距离小于一定阈值，则把当前簇归类为c2，否则聚类的类别+1；

   - 重复上述步骤直到所有点都遍历过；

   - 如果一个点既被簇c1遍历过，也被簇c2遍历过，则把其归类为标记数多的簇。

   下图显示了所有滑动窗口从头到尾的整个过程。每个黑点代表滑动窗口的质心，每个灰点代表一个数据点。

   [![y9ecWt.gif](https://s3.ax1x.com/2021/01/28/y9ecWt.gif)](https://imgchr.com/i/y9ecWt)

   优点：

   - 不同于K-Means算法，均值漂移聚类算法不需要我们知道有多少类/组。
   - 基于密度的算法相比于K-Means受均值影响较小。

   缺点：

   - 窗口半径、初始点的选择可能对结果造成很大影响。

5. 密度聚类（DBSCAN）

   DBSCAN是一种基于密度的算法，介绍它之前首先需要介绍几个会用到的概念：

   - $\epsilon-邻域$：给定对象的$\epsilon-邻域$为以该对象为圆心，$\epsilon$为半径的圆形区域；
   - 核心对象：$\epsilon-邻域$内包含样本数超过MinPts的样本；
   - 密度直达：如果样本a位于核心对象的$\epsilon-邻域$内，则称a由b密度直达；
   - 密度可达：如果存在对象序列$p_1,p_2,...,p_T$，其中$p_{t+1}$由$p_t$密度直达，则称$p_T$由$p_1$密度可达，此时$p_1,p_2,...,p_{T-1}$均为核心对象；
   - 密度相连：如果样本a和样本b都能够由样本c密度可达，则称a和b密度相连。

   从下图可以很容易看出理解上述定义，图中MinPts=5，红色的点都是核心对象，因为其$\epsilon-邻域$至少有5个样本。黑色的样本是非核心对象。所有核心对象密度直达的样本在以红色核心对象为中心的超球体内，如果不在超球体内，则不能密度直达。图中用绿色箭头连起来的核心对象组成了密度可达的样本序列。在这些密度可达的样本序列的$\epsilon-邻域$内所有的样本相互都是密度相连的。

   [![y9KCfs.png](https://s3.ax1x.com/2021/01/28/y9KCfs.png)](https://imgchr.com/i/y9KCfs)

   DBSCAN的聚类定义很简单：由密度可达关系导出的最大密度相连的样本集合，即为我们最终聚类的一个类别，或者说一个簇。

   DBSCAN的主要优点有：

   - 可以对任意形状的稠密数据集进行聚类，相对的，K-Means之类的聚类算法一般只适用于凸数据集
   -  可以在聚类的同时发现异常点，对数据集中的异常点不敏感；
   -  聚类结果没有偏倚，相对的，K-Means之类的聚类算法初始值对聚类结果有很大影响。

   DBSCAN的主要缺点有：

   - 如果样本集的密度不均匀，这时用DBSCAN聚类一般不适合；
   - 调参相对于传统的K-Means之类的聚类算法稍复杂，主要需要对距离阈值$\epsilon$，邻域样本数阈值MinPts联合调参，不同的参数组合对最后的聚类效果有较大影响。理论上$\epsilon$越大聚类数越少，MinPts越大聚类数越多。

6. 层次聚类（Hierarchical Clustering）

   层次聚类分为凝聚法和分裂法，凝聚法先将每个样本看成一类然后逐步合并，分裂法先将所有样本看成一类然后逐步分割。前者使用较多。

   - 凝聚法

     - 将样本集中的所有样本各归为一个类簇；
     - 计算各个类簇间的距离，选择距离最近的两个类簇进行合并；
     - 重复上一步直到剩下一个类簇或者到达设定的终止条件。

     两个类簇间的距离有如下几种算法：

     - 最大距离，选取两个类簇中所有点间距离的最大值；
     - 最小距离，选取两个类簇中所有点间距离的最小值；
     - 平均距离，选取两个类簇中所有点间距离的平均值；
     - 均值距离，选取两个类簇的均值的距离。

   - 分裂法

     - 将样本集中的所有样本归为同一个类簇；
     - 类簇中的任意两个数据点间的距离的最大值是簇的直径，选取直径最大类簇，在该类簇中找到与所有点的平均距离最大的点，将其单独分为一个新的类簇。称原类簇为old party，新类簇为splinter group；
     - 在old party里找出到splinter group中点的最近距离不大于该点到old party中点的最近距离的点，并将该点加入splinter group；
     - 重复上一步直到没有点可以加入splinter group；
     - old party和splinter group为两个新的类簇。如果此时已经到达了预设的停止条件或者每个类簇中都只有一个样本了则算法停止，否则从步骤二开始继续重复。

   层次聚类不需要提前指定类簇数，但其计算量很大，效率较低。

7. 聚类算法评估方法

   由于数据以及需求的多样性，没有一种算法能够适用于所有的数据类型、数 据簇或应用场景，似乎每种情况都可能需要一种不同的评估方法或度量标准。例如，K均值聚类可以用误差平方和来评估，但是基于密度的数据簇可能不是球形， 误差平方和则会失效。在许多情况下，判断聚类算法结果的好坏强烈依赖于主观解释。尽管如此，聚类算法的评估还是必需的，它是聚类分析中十分重要的部分之一。

   聚类评估的任务是估计在数据集上进行聚类的可行性，以及聚类方法产生结果的质量。这一过程又分为三个子任务。

   1. **估计聚类趋势。**

      这一步骤是检测数据分布中是否存在非随机的簇结构。如果数据是基本随机的，那么聚类的结果也是毫无意义的。我们可以观察聚类误差是否随聚类类别数量的增加而单调变化，如果数据是基本随机的，即不存在非随机簇结构，那么聚类误差随聚类类别数量增加而变化的幅度应该较不显著，并且也找不到一个合适 的K对应数据的真实簇数。

   2. **判定数据簇数。**

      确定聚类趋势之后，我们需要找到与真实数据分布最为吻合的簇数，据此判定聚类结果的质量。数据簇数的判定方法有很多，例如手肘法和交叉验证方 法。需要说明的是，用于评估的最佳数据簇数可能与程序输出的簇数是不同的。 例如，有些聚类算法可以自动地确定数据的簇数，但可能与我们通过其他方法确 定的最优数据簇数有所差别。具体可以参考[https://www.cnblogs.com/czhwust/p/mlclusterpre.html](https://www.cnblogs.com/czhwust/p/mlclusterpre.html)。

   3. **测定聚类质量。**

      在无监督的情况下，我们可以通过考察簇的分离情况和簇的紧 凑情况来评估聚类的效果。定义评估指标可以展现面试者实际解决和分析问题的 能力。测量指标有很多种，具体可以参考[https://zhuanlan.zhihu.com/p/115752696](https://zhuanlan.zhihu.com/p/115752696)。

   