1. 特征选择的目标

   构造机器学习的模型的目的是希望能够从原始的特征数据集中学习出问题的结构与问题的本质，此时的挑选出的特征就应该能够对问题有更好的解释；特征决定了机器学习的上限，而模型和算法只是去逼近这个上限，所以特征选择的目标大概如下：

   - 提高预测的准确性；
   - 减少模型的运行时间；
   - 能够对模型有更好的理解和解释。

2. Filter(过滤法)

   基本想法是：对每个特征，分别计算它相对于类别标签的信息量，将所有信息量按照从大到小排序，输出前 k 个特征。关键的问题就是使用什么样的方法来度量信息量。

   - 方差选择法

     首先计算各个特征的方差，然后根据阈值，选择方差大于阈值的特征。即去掉变化程度小的特征，这种方法是最简单的方法，但是并不好用，因为大部分特征并不是一成不变的。

   - Pearson相关系数

     Pearson相关系数衡量的是变量之间的线性相关性，结果的取值区间为[-1,1] ， -1 表示完全的负相关， +1 表示完全的正相关， 0 表示没有线性相关性。

     Pearson相关系数的计算公式为：
     $$
     \rho=\frac{\sum{(X-\overline X)(Y-\overline Y)}}{\sqrt{\sum{(X-\overline X)^2}}\sqrt{\sum{(Y-\overline Y)^2}}}
     $$
     即自变量与因变量协方差除以二者的标准差。

     Pearson相关系数的一个明显缺陷是它只对线性关系敏感。如果关系是非线性的，即便两个变量具有一一对应的关系，Pearson相关性也可能会接近 0 。

   - 卡方检验

     卡方检验是以卡方分布为基础的一种假设检验方法，用于检验类别型变量对类别型变量的相关性。

     假设自变量有N种取值，因变量有M种取值，考虑自变量等于i且因变量等于j的样本频数的观察值与期望的差距，构建统计量：
     $$
     \chi^2=\sum\frac{(A-E)^2}{E}
     $$
     其中E是假设自变量与因变量无关时自变量等于i且因变量等于j的理论值，A是观察值，卡方分布自由度为(N-1)*(M-1)，计算出统计量后通过查表可以得到该统计量对应的p-value即自变量与因变量无关的概率，一般取p-value小于0.05时原假设不成立，即此时认为自变量与因变量有关。

   - 互信息和最大信息系数

     互信息是一种衡量类别型变量对类别型变量的相关性的度量方式，其计算公式为：
     $$
     MI(X,Y)=\sum_{x,y}P(x,y)\log \frac{P(x,y)}{P(x)P(y)}
     $$
     可以看出互信息实际上是在计算联合分布P(X,Y)和边缘分布之积P(X)P(Y)的KL散度，若二者相关性越小则互信息也越小，反之越大。

     想把互信息直接用于特征选择其实不是太方便：

     1. 它不属于度量方式，也没有办法归一化，在不同数据及上的结果无法做比较。
     2. 对于连续变量的计算不是很方便，通常变量需要先离散化，而互信息的结果对离散化的方式很敏感。

     最大信息系数基于互信息并克服了以上两个缺点，它对X和Y的二维空间进行网格化来寻找一种最优的离散化方式，然后把最大的互信息进行归一化使其范围为[0,1]，其计算方式为：
     $$
     MIC(X,Y)=\max_{|X||Y|<B}\frac{MI(X,Y)}{\log \min(|X|,|Y|)}
     $$
     其中|X|和|Y|为对变量X和Y的划分数目，B 是变量，在原作者的论文当中提到 B 的大小设置是数据量的 0.6 次方左右。

     关于最大信息系数的详细内容可以参考[https://blog.csdn.net/qq_27586341/article/details/90603140](https://blog.csdn.net/qq_27586341/article/details/90603140)。

   - 距离相关系数

     皮尔逊相关系数只对线性关系敏感，距离相关系数是为了克服这一问题而提出的，其首先计算各个样本对间自变量的距离与因变量的距离，随后对其进行中心化处理，随后计算两组距离的相关系数，计算公式为：
     $$
     cor(X,Y)=\frac{\sum_{i=1}^n\sum_{j=1}^nA_{i,j}B_{i,j}}{\sqrt{\sum_{i=1}^n\sum_{j=1}^nA_{i,j}^2}\sqrt{\sum_{i=1}^n\sum_{j=1}^nB_{i,j}^2}}
     $$
     其中n为样本数量，A、B为中心化后的两组距离，其计算方式为：
     $$
     A_{i,j}=a_{i,j}-\overline a_{i.}-\overline a_{.j}+\overline a_{..}
     \\
     B_{i,j}=b_{i,j}-\overline b_{i.}-\overline b_{.j}+\overline b_{..}
     \\
     a_{i,j}=||x_i-x_j||
     \\
     b_{i,j}=||b_i-b_j||
     $$
     尽管有最大信息系数和距离相关系数在了，但当变量之间的关系接近线性相关的时候，Pearson相关系数仍然是不可替代的，原因有：

     - Pearson相关系数计算速度快，这在处理大规模数据的时候很重要。

     - Pearson相关系数的取值区间是[-1，1]，而MIC和距离相关系数都是[0，1]。这个特点使得Pearson相关系数能够表征更丰富的关系，符号表示关系的正负，绝对值能够表示强度。当然，Pearson相关性有效的前提是两个变量的变化关系是单调的。

3. Wrapper(包装法)

   基本思想：根据目标函数（往往是预测效果评分），每次选择若干特征，或者排除若干特征。对于每一个待选的特征子集，都在训练集上训练一遍模型，然后在验证集上根据误差大小选择出特征子集。一般欲训练什么算法，就选择该算法进行评估。

   穷举所有可能的特征组合虽然可以得到全局最优的组合，但是其计算复杂度太高，因此一般选用某些贪心算法代替。

   - 前向搜索

     设总的特征数为m，前向搜索每次增量地从剩余未选中的特征选出一个加入特征集中，待达到阈值或者m时，从所有尝试过的特征子集F中选出在验证集上错误率最小的。前向搜索的过程如下：

     1. 初始化特征集 F 为空。
     2. 令i从1到m，如果第i个特征不在F中，那么特征i和特征集F组合成F_i，利用交叉验证来得到F_i的错误率。
     3. 从上步中得到的所有F_i中选出错误率最小的F_i,更新特征集F为F_i 。
     4. 如果F中的特征数达到了m或者预定的阈值（如果有的话），那么输出整个搜索过程中最好的特征集 ；若没达到，则转到 2，继续扫描。

   - 后向搜索

     后向搜索算法与前向搜索算法相反，每次从现有特征集中选择一个特征删除并进行评价，直到达到阈值或者剩余特征集为空，然后从所有尝试过的特征子集F中选出在验证集上错误率最小的。后向搜索的过程如下：

     1. 初始化特征集 F 为所有特征。
     2. 令i从1到m，如果第i个特征在F中，那么在F中去除特征i形成F_i，利用交叉验证来得到F_i的错误率。
     3. 从上步中得到的所有F_i中选出错误率最小的F_i,更新特征集F为F_i 。
     4. 如果F中的特征数直到达到阈值（如果有的话）或者剩余特征集为空，那么输出整个搜索过程中最好的特征集 ；若没达到，则转到 2，继续扫描。

   - 递归特征消除

     递归特征消除的主要思想是反复的构建模型（如SVM或者回归模型）然后选出最好的（或者最差的）的特征（可以根据模型的系数来选择），把选出来的特征放到一遍，然后在剩余的特征上重复这个过程，直到所有特征都遍历了。这个过程中特征被消除的次序就是特征的排序。可以看出递归特征消除类似于后向算法，但其每次选择消除的特征的复杂度较小。

4. Embedded(嵌入法)

   先使用某些机器学习的模型进行训练，得到各个特征的权值系数，根据系数从大到小选择特征（类似于Filter，只不过系数是通过训练机器学习模型得来的）。

   - 基于惩罚项

     L1正则化具有得到稀疏解的特性，可以用来选择重要特征。但是L1正则化没有选到的特征不代表不重要，原因是两个具有高相关性的特征可能只保留了一个，如果要确定哪个特征重要应再通过L2正则方法交叉检验，具体具体操作为：若一个特征在L1中的权值为1，选择在L2中权值差别不大且在L1中权值为0的特征构成同类集合，将这一集合中的特征平分L1中的权值。

   - 基于树模型

     树模型天然具有特征选择的能力，决策树、随机森林、GBDT等树模型都可用来做特征选择，可以根据决策树分裂过程中的信息增益、信息增益率、基尼不纯度下降量等量的平均值或者总值来对特征进行排序，对于随机森林还可以使用袋外数据来获取特征的重要性。

