1. 什么是朴素贝叶斯

   朴素贝叶斯是基于贝叶斯定理与特征条件独立假设的分类方法。

   给定训练集$T={(x_1,y_1),(x_2,y_2),..,(x_N,y_N)}$，设类别可选数目为K，即$c_1,c_2,...,c_K$，特征维度为m，即$x_i=(x_i^1,x_i^2,...x_i^m)$，第j维的特征可取值数目为$S_j$，分别为$a_j^1,a_j^2,...,a_j^{S_j}$。

   朴素贝叶斯通过训练数据学习联合分布$P(X,Y)$，具体地，学习以下先验概率和条件概率。

   先验概率为：
   $$
   P(Y=c_k),k=1,2,...,K
   $$
   条件概率为：
   $$
   P(X=x|Y=c_k)=P(X^1=x^1,X^2=x^2,...,X^m=x^m|Y=c_k),k=1,2,...,K
   $$
   然后通过：
   $$
   p(X=x,Y=c_k)=P(Y=c_k)P(X=x|Y=c_k)
   $$
   来获得联合概率。

   为了降低模型的复杂度，朴素贝叶斯作了条件独立性的假设：
   $$
   P(X=x|Y=c_k)=P(X^1=x^1,X^2=x^2,...,X^m=x^m|Y=c_k)
   \\=\prod_{j=1}^mP(X^j=x^j|Y=c_k)
   $$
   朴素贝叶斯由此得名。由于朴素贝叶斯学习到了联合概率分布，因此为生成模型。

   对于后验概率$P(Y=C_K|X=x)$，由贝叶斯公式有：
   $$
   P(Y=C_K|X=x)=\frac{p(X=x,Y=c_k)}{P(X=x)}
   \\=\frac{P(Y=c_k)P(X=x|Y=c_k)}{P(X=x)}
   \\=\frac{P(Y=c_k)\prod_{j=1}^mP(X^j=x^j|Y=c_k)}{P(X=x)}
   $$
   选取后验概率最大的类别作为预测的样本类别，由于对于同一个样本的所有类别，上式分母相同，因此朴素贝叶斯最后预测的类别可以表示为：
   $$
   y=\arg \max_{c_k}P(Y=c_k)\prod_{j=1}^mP(X^j=x^j|Y=c_k)
   $$

2. 朴素贝叶斯的参数估计

   - 极大似然估计
     $$
     P(Y=c_k)=\frac{\sum_{i=1}^{N}I(y_i=c_k)}{N},k=1,2,...,K
     \\ P(X^{j}=a_j^l|Y=c_k)=\frac{\sum_{i=1}^{N}I(x_i^j=a_j^l,y_i=c_k)}{\sum_{i=1}^{N}I(y_i=c_k)},l=1,2,...,S_j
     $$
     其中I为指示函数。

   - 增加平滑项
     $$
     P(Y=c_k)=\frac{\sum_{i=1}^{N}I(y_i=c_k)+\lambda}{N+\lambda K},k=1,2,...,K
     \\ P(X^{j}=a_j^l|Y=c_k)=\frac{\sum_{i=1}^{N}I(x_i^j=a_j^l,y_i=c_k)+\lambda}{\sum_{i=1}^{N}I(y_i=c_k)+\lambda S_j},l=1,2,...,S_j
     $$
     $\lambda$为平滑因子，常取1，这时称为拉普拉斯平滑。

3. 三种朴素贝叶斯的实现

   三种实现差别主要体现在计算条件概率$P(X^{j}=a_j^l|Y=c_k)$。

   - 伯努利朴素贝叶斯

     适用于离散变量，假设各变量取值只有0、1两种，因此首先要对特征值进行二值化处理。

   - 多项式朴素贝叶斯

     适用于离散变量，其假设各个特征在各个类别下是服从多项式分布的，每个特征值不能是负数。

   - 高斯朴素贝叶斯

     适用于连续变量，其假定各个特征在各个类别下服从正态分布，通过训练集估计正态分布的参数。

   伯努利朴素贝叶斯和多项式朴素贝叶斯应用在文本分类时区别较大，详情可以参考：https://zhuanlan.zhihu.com/p/96007193。

   

