1. 什么是感知机

   感知机是一个二分类线性判别模型，假设输入$x\in \mathbb{R}^n$，输出$y\in\{-1,+1\}$，感知机为如下函数：
   $$
   f(x)=sign(w^Tx+b),
   \\sign(z)=\left\{\begin{aligned}
   1 \qquad \quad x\ge0\\
   -1 \qquad\quad x<0
   \end{aligned}\right.
   $$
   其中，w叫做权重，是分类超平面的法向量；b叫做偏置，是超平面的截距。

   设数据集线性可分，感知机的损失函数为所有误分类点到分类超平面的函数间隔，即：
   $$
   L(w,b)=-\sum_{x_i\in M}y_i(w^Tx+b)
   $$
   其中M为所有误分类点的集合。

   - 为什么感知机不使用几何间隔

     由于感知机的前提是原数据集线性可分，这意味着必须存在一个正确的超平面。那么，不管几何距离还是函数距离，损失函数最后都要等于0，因此感知机并不关心点到超平面之间的间隔，关心的是误分类的点的个数。采用几何间隔并不会带来什么好处，反而会使学习过程复杂化。

2. 感知机学习算法的原始形式

   输入：训练数据集$T={(x_1,y_1),(x_2,y_2),..,(x_N,y_N)}$，其中$x_i\in \mathbb{R}^n$，$Y_i\in\{-1,1\}$；学习率$\eta\in(0,1]$

   输出：w,b；感知机模型$f(x)=sign(w^Tx+b)$

   - 随机任选一个超平面$w_0,b_0$，一般都初始化为0

   - 在训练集中选取数据$(x_i,y_i)$

   - 如果$y_i(w^Tx_i+b)\le 0$，则更新w和b：
     $$
     w=w+\eta y_ix_i
     \\b=b+\eta y_i
     $$

   - 转至第二步，直到训练集中没有误分点

3. 感知机学习算法的对偶形式

   对偶形式的基本想法是，将w和b表示为实例$x_i$和标签$y_i$的线性组合的形式，通过求解其系数而求得w和b。

   由感知机算法的原始形式可以得出，修改n次过后w，b关于$(x_i,y_i)$的增量分别是$\alpha_iy_ix_i$和$\alpha_iy_i$，这里$\alpha_i=n_i\eta$。这样，最后学习到的w和b可以分别表示为：
   $$
   w=\sum_{i=1}^N\alpha_iy_ix_i
   \\b=\sum_{i=1}^N\alpha_iy_i
   $$
   具体算法为：

   输入：训练数据集$T={(x_1,y_1),(x_2,y_2),..,(x_N,y_N)}$，其中$x_i\in \mathbb{R}^n$，$Y_i\in\{-1,1\}$；学习率$\eta\in(0,1]$

   输出：$\alpha$,b；感知机模型$f(x)=sign(\sum_{i=1}^N\alpha_iy_ix_ix+b)$，其中$\alpha=(\alpha_1,\alpha_2,...,\alpha_N)^T$

   - 令$\alpha=\boldsymbol 0, b=0$

   - 在训练集中选取数据$(x_i,y_i)$

   - 如果$y_i(\sum_{j=1}^N\alpha_jy_jx_jx_i+b)\le 0$，则更新w和b：
     $$
     \alpha=\alpha+\eta
     \\b=b+\eta y_i
     $$

   - 转至第二步，知道训练集中没有误分点

   感知机算法的对偶形式主要适用于训练数据的特征维度远大于训练样本数的场景，此时原始形式每次更新都需要计算w和x的内积，但对偶形式可以将所有样本间的内积预先计算好以矩阵的形式存储(Gram矩阵)，这样会节省训练耗时。





