1. 什么是GBDT

   - Boosting思想

     Boosting方法训练基分类器时采用串行的方式，各个基分类器之间有依赖。它的基本思路是将基分类器层层叠加，每一层在训练的时候，对前一层基分类器分错的样本，给予更高的权重。测试时，根据各层分类器的结果的加权得到最终结果。

     Bagging与Boosting的串行训练方式不同，Bagging方法在训练过程中，各基分类器之间无强依赖，可以进行并行训练。

   - GBDT思想

     GBDT是boosting算法的一种，按照boosting的思想，在GBDT算法的每一步，用一棵决策树去拟合当前学习器的残差，获得一个新的弱学习器。将这每一步的决策树组合起来，就得到了一个强学习器。

     GBDT的基模型为CART。

2. GBDT用于回归

   - 使用平方误差$\frac{1}{2}(y-f)^2$作为损失函数，其中y为真实输出，f为模型输出。

   - 设GBDT中存在M个CART，分别为$T_1,T_2,...,T_M$，GBDT的最终输出为$f_M=\sum_{i=1}^MT_i$。

     $f_{i+1}=f_i+T_{i+1}$，前i棵树的输出$f_i$的损失为$Loss=\frac{1}{2}(f_i-y)^2$，$Loss$对$f_i$的负梯度为$J=-\frac{\partial{Loss}}{\partial{f_i}}=y-f_i$。即当损失函数选用均方损失函数时，每一次拟合的值就是（真实值 - 当前模型预测的值），即残差。

     采用类似梯度下降法的思想，$f_{i+1}=f_i+\alpha{J}$，其中$\alpha$为学习率，则$T_{i+1}={\alpha}J$。

3. GBDT用于分类

   - 以二分类为例，GBDT用于分类并不直接拟合类别标签，而是去拟合对数几率$\ln \frac{p}{1-p}$，实际上最终得到的是一系列CART回归树，即$f_M=\sum_{i=1}^MT_i=\ln \frac{\hat{p}}{1-\hat{p}}$，即$\hat{p}=\frac{1}{1+e^{-f_M}}$,其中$\hat{p}$为模型预测的标签。

     二分类以$Loss=-p\log\hat{p}-(1-p)\log({1-\hat{p}})$为损失函数，将$\hat{p}=\frac{1}{1+e^{-f_M}}$代入后计算Loss对$f_i$的负梯度为$J=-\frac{\partial{Loss}}{\partial{f_i}}=p-\hat{p}$

   - 对于多分类问题，负梯度同样是$p-\hat{p}$，具体需要参考Softmax的求导过程。

4. GBDT的优点

   - 预测阶段的计算速度快，树与树之间可并行化计算。
   - 学习能力非常强，在各类竞赛中经常名列榜首。

5. GBDT的缺点
   - 训练过程需要串行训练，只能在决策树内部采用一些局部并行的手段提高训练速度。
   - 容易过拟合。

6. GBDT与RF的区别与联系

   **相同点**：

   - 都是由多棵树组成，最终的结果都是由多棵树一起决定。
   - RF和GBDT在使用CART树时，可以是分类树或者回归树。

   **不同点**：

   - 组成随机森林的树可以并行生成，而GBDT是串行生成。
   - 随机森林的结果是多数表决的，而GBDT则是多棵树累加之和。
   - 随机森林对异常值不敏感，而GBDT对异常值比较敏感。
   - 随机森林是减少模型的方差，而GBDT是减少模型的偏差。

