#include "../INCLUDE/libt.h"
#include "../INCLUDE/system.h"
#include "../INCLUDE/display.h"
#include "../INCLUDE/typedefs.h"

void	write_to_ports(u8 *val){
	
	Pbyte_out(MISC_OUTPUT_REG_WR, *val);
	val++;
	for (u8 i = 0; i < 5; i++)
	{
		Pbyte_out(SEQ_REG_ADDR, i);
		Pbyte_out(SEQ_REG_DATA, *val);
		val++;
	}
	Pbyte_out(CRTC_REG_ADDR, 0x03);
	Pbyte_out(CRTC_REG_DATA, Pbyte_in(CRTC_REG_DATA) | 0x80);
	Pbyte_out(CRTC_REG_ADDR, 0x11);
	Pbyte_out(CRTC_REG_DATA, Pbyte_in(CRTC_REG_DATA) & ~0x80);
	val[0x03] |= 0x80;
	val[0x11] &= ~0x80;
	for(u8 i = 0; i < 25; i++)
	{
		Pbyte_out(CRTC_REG_ADDR, i);
		Pbyte_out(CRTC_REG_DATA, *val);
		val++;
	}
	for(u8 i = 0; i < 9; i++)
	{
		Pbyte_out(GRAP_REG_ADDR, i);
		Pbyte_out(GRAP_REG_DATA, *val);
		val++;
	}
	for(u8 i = 0; i < 21; i++)
	{
		(void)Pbyte_in(FEATURE_CTRL_REG);
		Pbyte_out(ATTR_REG_ADDR, i);
		Pbyte_out(ATTR_REG_DATA, *val);
		val++;
	}
	(void)Pbyte_in(FEATURE_CTRL_REG);
	Pbyte_out(ATTR_REG_ADDR, 0x20);
}

u32	text80x25(){
	u8 g_80x25_text[] =
	{
	/* MISC */
		0x67,
	/* SEQ */
		0x03, 0x00, 0x03, 0x00, 0x02,
	/* CRTC */
		0x5F, 0x4F, 0x50, 0x82, 0x55, 0x81, 0xBF, 0x1F,
		0x00, 0x4F, 0x0D, 0x0E, 0x00, 0x00, 0x00, 0x50,
		0x9C, 0x0E, 0x8F, 0x28, 0x1F, 0x96, 0xB9, 0xA3,
		0xFF,
	/* GC */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00,
		0xFF,
	/* AC */
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,
		0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
		0x0C, 0x00, 0x0F, 0x08, 0x00
	};
	write_to_ports(g_80x25_text);
	return 0;
}

u32	video320x200x256(){
	u8 g_320x200x256[] =
	{
	/* MISC */
		0x63,
	/* SEQ */
		0x03, 0x01, 0x0F, 0x00, 0x0E,
	/* CRTC */
		0x5F, 0x4F, 0x50, 0x82, 0x54, 0x80, 0xBF, 0x1F,
		0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x9C, 0x0E, 0x8F, 0x28,	0x40, 0x96, 0xB9, 0xA3,
		0xFF,
	/* GC */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x05, 0x0F,
		0xFF,
	/* AC */
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
		0x41, 0x00, 0x0F, 0x00,	0x00
	};
	write_to_ports(g_320x200x256);
	return 0;
}

void	change_vga_mode(u8 mode){
	(mode == TEXT_MODE_80x25) && text80x25();
	(mode == VIDEO_MODE_320x200x256) && video320x200x256();
}